// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.serde

import aws.sdk.kotlin.services.s3vectors.model.QueryOutputVector
import aws.sdk.kotlin.services.s3vectors.model.QueryVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.S3VectorsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class QueryVectorsOperationDeserializer: HttpDeserializer.NonStreaming<QueryVectorsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): QueryVectorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryVectorsError(context, call, payload)
        }
        val builder = QueryVectorsResponse.Builder()

        if (payload != null) {
            deserializeQueryVectorsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwQueryVectorsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw S3VectorsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KmsDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> S3VectorsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryVectorsOperationBody(builder: QueryVectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vectors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VECTORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VECTORS_DESCRIPTOR.index -> builder.vectors =
                    deserializer.deserializeList(VECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryOutputVector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryOutputVectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
