// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.serde

import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.S3VectorsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteVectorsOperationDeserializer: HttpDeserializer.NonStreaming<DeleteVectorsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteVectorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteVectorsError(context, call, payload)
        }
        val builder = DeleteVectorsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteVectorsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw S3VectorsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsInvalidKeyUsageException" -> KmsInvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> S3VectorsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
