// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.paginators

import aws.sdk.kotlin.services.s3vectors.S3VectorsClient
import aws.sdk.kotlin.services.s3vectors.model.IndexSummary
import aws.sdk.kotlin.services.s3vectors.model.ListIndexesRequest
import aws.sdk.kotlin.services.s3vectors.model.ListIndexesResponse
import aws.sdk.kotlin.services.s3vectors.model.ListOutputVector
import aws.sdk.kotlin.services.s3vectors.model.ListVectorBucketsRequest
import aws.sdk.kotlin.services.s3vectors.model.ListVectorBucketsResponse
import aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.ListVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.VectorBucketSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListIndexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIndexesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndexesResponse]
 */
public fun S3VectorsClient.listIndexesPaginated(initialRequest: ListIndexesRequest = ListIndexesRequest { }): Flow<ListIndexesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIndexesPaginated.listIndexes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIndexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndexesResponse]
 */
public fun S3VectorsClient.listIndexesPaginated(block: ListIndexesRequest.Builder.() -> Unit): Flow<ListIndexesResponse> =
    listIndexesPaginated(ListIndexesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIndexesPaginated]
 * to access the nested member [IndexSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IndexSummary]
 */
@JvmName("listIndexesResponseIndexSummary")
public fun Flow<ListIndexesResponse>.indexes(): Flow<IndexSummary> =
    transform() { response ->
        response.indexes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVectorBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVectorBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorBucketsResponse]
 */
public fun S3VectorsClient.listVectorBucketsPaginated(initialRequest: ListVectorBucketsRequest = ListVectorBucketsRequest { }): Flow<ListVectorBucketsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVectorBucketsPaginated.listVectorBuckets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVectorBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorBucketsResponse]
 */
public fun S3VectorsClient.listVectorBucketsPaginated(block: ListVectorBucketsRequest.Builder.() -> Unit): Flow<ListVectorBucketsResponse> =
    listVectorBucketsPaginated(ListVectorBucketsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVectorBucketsPaginated]
 * to access the nested member [VectorBucketSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VectorBucketSummary]
 */
@JvmName("listVectorBucketsResponseVectorBucketSummary")
public fun Flow<ListVectorBucketsResponse>.vectorBuckets(): Flow<VectorBucketSummary> =
    transform() { response ->
        response.vectorBuckets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorsResponse]
 */
public fun S3VectorsClient.listVectorsPaginated(initialRequest: ListVectorsRequest = ListVectorsRequest { }): Flow<ListVectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVectorsPaginated.listVectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorsResponse]
 */
public fun S3VectorsClient.listVectorsPaginated(block: ListVectorsRequest.Builder.() -> Unit): Flow<ListVectorsResponse> =
    listVectorsPaginated(ListVectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVectorsPaginated]
 * to access the nested member [ListOutputVector]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOutputVector]
 */
@JvmName("listVectorsResponseListOutputVector")
public fun Flow<ListVectorsResponse>.vectors(): Flow<ListOutputVector> =
    transform() { response ->
        response.vectors?.forEach {
            emit(it)
        }
    }
