// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListVectorsRequest private constructor(builder: Builder) {
    /**
     * The Amazon resource Name (ARN) of the vector index.
     */
    public val indexArn: kotlin.String? = builder.indexArn
    /**
     * The name of the vector index.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The maximum number of vectors to return on a page.
     *
     * If you don't specify `maxResults`, the `ListVectors` operation uses a default value of 500.
     *
     * If the processed dataset size exceeds 1 MB before reaching the `maxResults` value, the operation stops and returns the vectors that are retrieved up to that point, along with a `nextToken` that you can use in a subsequent request to retrieve the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Pagination token from a previous request. The value of this field is empty for an initial request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If true, the vector data of each vector will be included in the response. The default value is `false`.
     */
    public val returnData: kotlin.Boolean? = builder.returnData
    /**
     * If true, the metadata associated with each vector will be included in the response. The default value is `false`.
     */
    public val returnMetadata: kotlin.Boolean? = builder.returnMetadata
    /**
     * For a parallel `ListVectors` request, `segmentCount` represents the total number of vector segments into which the `ListVectors` operation will be divided. The value of `segmentCount` corresponds to the number of application workers that will perform the parallel `ListVectors` operation. For example, if you want to use four application threads to list vectors in a vector index, specify a `segmentCount` value of 4.
     *
     * If you specify a `segmentCount` value of 1, the `ListVectors` operation will be sequential rather than parallel.
     *
     * If you specify `segmentCount`, you must also specify `segmentIndex`.
     */
    public val segmentCount: kotlin.Int? = builder.segmentCount
    /**
     * For a parallel `ListVectors` request, `segmentIndex` is the index of the segment from which to list vectors in the current request. It identifies an individual segment to be listed by an application worker.
     *
     * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to list vectors in a vector index, then the first thread specifies a `segmentIndex` value of 0, the second thread specifies 1, and so on.
     *
     * The value of `segmentIndex` must be less than the value provided for `segmentCount`.
     *
     * If you provide `segmentIndex`, you must also provide `segmentCount`.
     */
    public val segmentIndex: kotlin.Int? = builder.segmentIndex
    /**
     * The name of the vector bucket.
     */
    public val vectorBucketName: kotlin.String? = builder.vectorBucketName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListVectorsRequest(")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("returnData=$returnData,")
        append("returnMetadata=$returnMetadata,")
        append("segmentCount=$segmentCount,")
        append("segmentIndex=$segmentIndex,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexArn?.hashCode() ?: 0
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (returnData?.hashCode() ?: 0)
        result = 31 * result + (returnMetadata?.hashCode() ?: 0)
        result = 31 * result + (segmentCount ?: 0)
        result = 31 * result + (segmentIndex ?: 0)
        result = 31 * result + (vectorBucketName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListVectorsRequest

        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (returnData != other.returnData) return false
        if (returnMetadata != other.returnMetadata) return false
        if (segmentCount != other.segmentCount) return false
        if (segmentIndex != other.segmentIndex) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon resource Name (ARN) of the vector index.
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the vector index.
         */
        public var indexName: kotlin.String? = null
        /**
         * The maximum number of vectors to return on a page.
         *
         * If you don't specify `maxResults`, the `ListVectors` operation uses a default value of 500.
         *
         * If the processed dataset size exceeds 1 MB before reaching the `maxResults` value, the operation stops and returns the vectors that are retrieved up to that point, along with a `nextToken` that you can use in a subsequent request to retrieve the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Pagination token from a previous request. The value of this field is empty for an initial request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * If true, the vector data of each vector will be included in the response. The default value is `false`.
         */
        public var returnData: kotlin.Boolean? = null
        /**
         * If true, the metadata associated with each vector will be included in the response. The default value is `false`.
         */
        public var returnMetadata: kotlin.Boolean? = null
        /**
         * For a parallel `ListVectors` request, `segmentCount` represents the total number of vector segments into which the `ListVectors` operation will be divided. The value of `segmentCount` corresponds to the number of application workers that will perform the parallel `ListVectors` operation. For example, if you want to use four application threads to list vectors in a vector index, specify a `segmentCount` value of 4.
         *
         * If you specify a `segmentCount` value of 1, the `ListVectors` operation will be sequential rather than parallel.
         *
         * If you specify `segmentCount`, you must also specify `segmentIndex`.
         */
        public var segmentCount: kotlin.Int? = null
        /**
         * For a parallel `ListVectors` request, `segmentIndex` is the index of the segment from which to list vectors in the current request. It identifies an individual segment to be listed by an application worker.
         *
         * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to list vectors in a vector index, then the first thread specifies a `segmentIndex` value of 0, the second thread specifies 1, and so on.
         *
         * The value of `segmentIndex` must be less than the value provided for `segmentCount`.
         *
         * If you provide `segmentIndex`, you must also provide `segmentCount`.
         */
        public var segmentIndex: kotlin.Int? = null
        /**
         * The name of the vector bucket.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest) : this() {
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.returnData = x.returnData
            this.returnMetadata = x.returnMetadata
            this.segmentCount = x.segmentCount
            this.segmentIndex = x.segmentIndex
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest = ListVectorsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
