// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ObjectLambdaAccessPoint
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListAccessPointsForObjectLambdaOperationDeserializer: HttpDeserialize<ListAccessPointsForObjectLambdaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAccessPointsForObjectLambdaResponse {
        if (!response.status.isSuccess()) {
            throwListAccessPointsForObjectLambdaError(context, response)
        }
        val builder = ListAccessPointsForObjectLambdaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAccessPointsForObjectLambdaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAccessPointsForObjectLambdaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAccessPointsForObjectLambdaOperationBody(builder: ListAccessPointsForObjectLambdaResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJECTLAMBDAACCESSPOINTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ObjectLambdaAccessPointList"), XmlCollectionName("ObjectLambdaAccessPoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListAccessPointsForObjectLambdaResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(NEXTTOKEN_DESCRIPTOR)
        field(OBJECTLAMBDAACCESSPOINTLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                OBJECTLAMBDAACCESSPOINTLIST_DESCRIPTOR.index -> builder.objectLambdaAccessPointList =
                    deserializer.deserializeList(OBJECTLAMBDAACCESSPOINTLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ObjectLambdaAccessPoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeObjectLambdaAccessPointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
