// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container to specify the properties of your S3 Storage Lens metrics export, including the destination, schema, and format.
 */
public class StorageLensDataExport private constructor(builder: Builder) {
    /**
     * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
     */
    public val cloudWatchMetrics: aws.sdk.kotlin.services.s3control.model.CloudWatchMetrics? = builder.cloudWatchMetrics
    /**
     * A container for the bucket where the S3 Storage Lens metrics export will be located.
     *
     * This bucket must be located in the same Region as the storage lens configuration.
     */
    public val s3BucketDestination: aws.sdk.kotlin.services.s3control.model.S3BucketDestination? = builder.s3BucketDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.StorageLensDataExport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageLensDataExport(")
        append("cloudWatchMetrics=$cloudWatchMetrics,")
        append("s3BucketDestination=$s3BucketDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchMetrics?.hashCode() ?: 0
        result = 31 * result + (s3BucketDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageLensDataExport

        if (cloudWatchMetrics != other.cloudWatchMetrics) return false
        if (s3BucketDestination != other.s3BucketDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.StorageLensDataExport = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
         */
        public var cloudWatchMetrics: aws.sdk.kotlin.services.s3control.model.CloudWatchMetrics? = null
        /**
         * A container for the bucket where the S3 Storage Lens metrics export will be located.
         *
         * This bucket must be located in the same Region as the storage lens configuration.
         */
        public var s3BucketDestination: aws.sdk.kotlin.services.s3control.model.S3BucketDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.StorageLensDataExport) : this() {
            this.cloudWatchMetrics = x.cloudWatchMetrics
            this.s3BucketDestination = x.s3BucketDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.StorageLensDataExport = StorageLensDataExport(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.CloudWatchMetrics] inside the given [block]
         */
        public fun cloudWatchMetrics(block: aws.sdk.kotlin.services.s3control.model.CloudWatchMetrics.Builder.() -> kotlin.Unit) {
            this.cloudWatchMetrics = aws.sdk.kotlin.services.s3control.model.CloudWatchMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3BucketDestination] inside the given [block]
         */
        public fun s3BucketDestination(block: aws.sdk.kotlin.services.s3control.model.S3BucketDestination.Builder.() -> kotlin.Unit) {
            this.s3BucketDestination = aws.sdk.kotlin.services.s3control.model.S3BucketDestination.invoke(block)
        }
    }
}
