// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying `PutObjectRetention` API operation. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
 */
public class S3SetObjectRetentionOperation private constructor(builder: Builder) {
    /**
     * Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock ` GOVERNANCE` type in place.
     */
    public val bypassGovernanceRetention: kotlin.Boolean? = builder.bypassGovernanceRetention
    /**
     * Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
     */
    public val retention: aws.sdk.kotlin.services.s3control.model.S3Retention? = builder.retention

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3SetObjectRetentionOperation(")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("retention=$retention")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassGovernanceRetention?.hashCode() ?: 0
        result = 31 * result + (retention?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3SetObjectRetentionOperation

        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (retention != other.retention) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock ` GOVERNANCE` type in place.
         */
        public var bypassGovernanceRetention: kotlin.Boolean? = null
        /**
         * Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
         */
        public var retention: aws.sdk.kotlin.services.s3control.model.S3Retention? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation) : this() {
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.retention = x.retention
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation = S3SetObjectRetentionOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3Retention] inside the given [block]
         */
        public fun retention(block: aws.sdk.kotlin.services.s3control.model.S3Retention.Builder.() -> kotlin.Unit) {
            this.retention = aws.sdk.kotlin.services.s3control.model.S3Retention.invoke(block)
        }
    }
}
