// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` element must specify exactly one `Prefix`, `Tag`, or `And` child element.
 */
public class ReplicationRuleFilter private constructor(builder: Builder) {
    /**
     * A container for specifying rule filters. The filters determine the subset of objects that the rule applies to. This element is required only if you specify more than one filter. For example:
     * + If you specify both a `Prefix` and a `Tag` filter, wrap these filters in an `And` element.
     * + If you specify a filter based on multiple tags, wrap the `Tag` elements in an `And` element.
     */
    public val and: aws.sdk.kotlin.services.s3control.model.ReplicationRuleAndOperator? = builder.and
    /**
     * An object key name prefix that identifies the subset of objects that the rule applies to.
     *
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * A container for a key-value name pair.
     */
    public val tag: aws.sdk.kotlin.services.s3control.model.S3Tag? = builder.tag

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationRuleFilter(")
        append("and=$and,")
        append("prefix=$prefix,")
        append("tag=$tag")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = and?.hashCode() ?: 0
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (tag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationRuleFilter

        if (and != other.and) return false
        if (prefix != other.prefix) return false
        if (tag != other.tag) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for specifying rule filters. The filters determine the subset of objects that the rule applies to. This element is required only if you specify more than one filter. For example:
         * + If you specify both a `Prefix` and a `Tag` filter, wrap these filters in an `And` element.
         * + If you specify a filter based on multiple tags, wrap the `Tag` elements in an `And` element.
         */
        public var and: aws.sdk.kotlin.services.s3control.model.ReplicationRuleAndOperator? = null
        /**
         * An object key name prefix that identifies the subset of objects that the rule applies to.
         *
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see [ XML-related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) in the *Amazon S3 User Guide*.
         */
        public var prefix: kotlin.String? = null
        /**
         * A container for a key-value name pair.
         */
        public var tag: aws.sdk.kotlin.services.s3control.model.S3Tag? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter) : this() {
            this.and = x.and
            this.prefix = x.prefix
            this.tag = x.tag
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ReplicationRuleFilter = ReplicationRuleFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ReplicationRuleAndOperator] inside the given [block]
         */
        public fun and(block: aws.sdk.kotlin.services.s3control.model.ReplicationRuleAndOperator.Builder.() -> kotlin.Unit) {
            this.and = aws.sdk.kotlin.services.s3control.model.ReplicationRuleAndOperator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3Tag] inside the given [block]
         */
        public fun tag(block: aws.sdk.kotlin.services.s3control.model.S3Tag.Builder.() -> kotlin.Unit) {
            this.tag = aws.sdk.kotlin.services.s3control.model.S3Tag.invoke(block)
        }
    }
}
