// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



public class CreateAccessPointRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID for the account that owns the specified access point.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The name of the bucket that you want to associate this access point with.
     *
     * For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.
     *
     * For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`. For example, to access the bucket `reports` through Outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`. The value must be URL encoded.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
     */
    public val bucketAccountId: kotlin.String? = builder.bucketAccountId
    /**
     * The name you want to assign to this access point.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The `PublicAccessBlock` configuration that you want to apply to the access point.
     */
    public val publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = builder.publicAccessBlockConfiguration
    /**
     * If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).
     *
     * This is required for creating an access point for Amazon S3 on Outposts buckets.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPointRequest(")
        append("accountId=$accountId,")
        append("bucket=$bucket,")
        append("bucketAccountId=$bucketAccountId,")
        append("name=$name,")
        append("publicAccessBlockConfiguration=$publicAccessBlockConfiguration,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (bucketAccountId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlockConfiguration?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessPointRequest

        if (accountId != other.accountId) return false
        if (bucket != other.bucket) return false
        if (bucketAccountId != other.bucketAccountId) return false
        if (name != other.name) return false
        if (publicAccessBlockConfiguration != other.publicAccessBlockConfiguration) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID for the account that owns the specified access point.
         */
        public var accountId: kotlin.String? = null
        /**
         * The name of the bucket that you want to associate this access point with.
         *
         * For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.
         *
         * For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`. For example, to access the bucket `reports` through Outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`. The value must be URL encoded.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
         */
        public var bucketAccountId: kotlin.String? = null
        /**
         * The name you want to assign to this access point.
         */
        public var name: kotlin.String? = null
        /**
         * The `PublicAccessBlock` configuration that you want to apply to the access point.
         */
        public var publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = null
        /**
         * If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).
         *
         * This is required for creating an access point for Amazon S3 on Outposts buckets.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest) : this() {
            this.accountId = x.accountId
            this.bucket = x.bucket
            this.bucketAccountId = x.bucketAccountId
            this.name = x.name
            this.publicAccessBlockConfiguration = x.publicAccessBlockConfiguration
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest = CreateAccessPointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun publicAccessBlockConfiguration(block: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlockConfiguration = aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.s3control.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.s3control.model.VpcConfiguration.invoke(block)
        }
    }
}
