// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointReport
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListMultiRegionAccessPointsOperationDeserializer: HttpDeserialize<ListMultiRegionAccessPointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListMultiRegionAccessPointsResponse {
        if (!response.status.isSuccess()) {
            throwListMultiRegionAccessPointsError(context, response)
        }
        val builder = ListMultiRegionAccessPointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMultiRegionAccessPointsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListMultiRegionAccessPointsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListMultiRegionAccessPointsOperationBody(builder: ListMultiRegionAccessPointsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ACCESSPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AccessPoints"), XmlCollectionName("AccessPoint"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListMultiRegionAccessPointsResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ACCESSPOINTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOINTS_DESCRIPTOR.index -> builder.accessPoints =
                    deserializer.deserializeList(ACCESSPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<MultiRegionAccessPointReport>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMultiRegionAccessPointReportDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
