// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ObjectLambdaAccessPointAlias
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateAccessPointForObjectLambdaOperationDeserializer: HttpDeserialize<CreateAccessPointForObjectLambdaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateAccessPointForObjectLambdaResponse {
        if (!response.status.isSuccess()) {
            throwCreateAccessPointForObjectLambdaError(context, response)
        }
        val builder = CreateAccessPointForObjectLambdaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAccessPointForObjectLambdaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateAccessPointForObjectLambdaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessPointForObjectLambdaOperationBody(builder: CreateAccessPointForObjectLambdaResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Alias"))
    val OBJECTLAMBDAACCESSPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ObjectLambdaAccessPointArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAccessPointForObjectLambdaResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ALIAS_DESCRIPTOR)
        field(OBJECTLAMBDAACCESSPOINTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeObjectLambdaAccessPointAliasDocument(deserializer)
                OBJECTLAMBDAACCESSPOINTARN_DESCRIPTOR.index -> builder.objectLambdaAccessPointArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
