// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.
 */
public class SourceSelectionCriteria private constructor(builder: Builder) {
    /**
     * A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3 on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the replication bidirectional.
     *
     * To replicate object metadata modifications on replicas, you can specify this element and set the `Status` of this element to `Enabled`.
     *
     * You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes between the source and the replicas.
     */
    public val replicaModifications: aws.sdk.kotlin.services.s3control.model.ReplicaModifications? = builder.replicaModifications
    /**
     * A filter that you can use to select Amazon S3 objects that are encrypted with server-side encryption by using Key Management Service (KMS) keys. If you include `SourceSelectionCriteria` in the replication configuration, this element is required.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    public val sseKmsEncryptedObjects: aws.sdk.kotlin.services.s3control.model.SseKmsEncryptedObjects? = builder.sseKmsEncryptedObjects

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceSelectionCriteria(")
        append("replicaModifications=$replicaModifications,")
        append("sseKmsEncryptedObjects=$sseKmsEncryptedObjects")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = replicaModifications?.hashCode() ?: 0
        result = 31 * result + (sseKmsEncryptedObjects?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceSelectionCriteria

        if (replicaModifications != other.replicaModifications) return false
        if (sseKmsEncryptedObjects != other.sseKmsEncryptedObjects) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3 on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the replication bidirectional.
         *
         * To replicate object metadata modifications on replicas, you can specify this element and set the `Status` of this element to `Enabled`.
         *
         * You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes between the source and the replicas.
         */
        public var replicaModifications: aws.sdk.kotlin.services.s3control.model.ReplicaModifications? = null
        /**
         * A filter that you can use to select Amazon S3 objects that are encrypted with server-side encryption by using Key Management Service (KMS) keys. If you include `SourceSelectionCriteria` in the replication configuration, this element is required.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        public var sseKmsEncryptedObjects: aws.sdk.kotlin.services.s3control.model.SseKmsEncryptedObjects? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria) : this() {
            this.replicaModifications = x.replicaModifications
            this.sseKmsEncryptedObjects = x.sseKmsEncryptedObjects
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.SourceSelectionCriteria = SourceSelectionCriteria(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ReplicaModifications] inside the given [block]
         */
        public fun replicaModifications(block: aws.sdk.kotlin.services.s3control.model.ReplicaModifications.Builder.() -> kotlin.Unit) {
            this.replicaModifications = aws.sdk.kotlin.services.s3control.model.ReplicaModifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.SseKmsEncryptedObjects] inside the given [block]
         */
        public fun sseKmsEncryptedObjects(block: aws.sdk.kotlin.services.s3control.model.SseKmsEncryptedObjects.Builder.() -> kotlin.Unit) {
            this.sseKmsEncryptedObjects = aws.sdk.kotlin.services.s3control.model.SseKmsEncryptedObjects.invoke(block)
        }
    }
}
