// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3 on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the replication bidirectional.
 *
 * To replicate object metadata modifications on replicas, you can specify this element and set the `Status` of this element to `Enabled`.
 *
 * You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes between the source and the replicas.
 */
public class ReplicaModifications private constructor(builder: Builder) {
    /**
     * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.ReplicaModificationsStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ReplicaModifications = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicaModifications(")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicaModifications

        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ReplicaModifications = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.ReplicaModificationsStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ReplicaModifications) : this() {
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ReplicaModifications = ReplicaModifications(this)
    }
}
