// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A configuration used when creating an Object Lambda Access Point.
 */
public class ObjectLambdaConfiguration private constructor(builder: Builder) {
    /**
     * A container for allowed features. Valid inputs are `GetObject-Range`, `GetObject-PartNumber`, `HeadObject-Range`, and `HeadObject-PartNumber`.
     */
    public val allowedFeatures: List<ObjectLambdaAllowedFeature>? = builder.allowedFeatures
    /**
     * A container for whether the CloudWatch metrics configuration is enabled.
     */
    public val cloudWatchMetricsEnabled: kotlin.Boolean = builder.cloudWatchMetricsEnabled
    /**
     * Standard access point associated with the Object Lambda Access Point.
     */
    public val supportingAccessPoint: kotlin.String? = builder.supportingAccessPoint
    /**
     * A container for transformation configurations for an Object Lambda Access Point.
     */
    public val transformationConfigurations: List<ObjectLambdaTransformationConfiguration>? = builder.transformationConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ObjectLambdaConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectLambdaConfiguration(")
        append("allowedFeatures=$allowedFeatures,")
        append("cloudWatchMetricsEnabled=$cloudWatchMetricsEnabled,")
        append("supportingAccessPoint=$supportingAccessPoint,")
        append("transformationConfigurations=$transformationConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedFeatures?.hashCode() ?: 0
        result = 31 * result + (cloudWatchMetricsEnabled.hashCode())
        result = 31 * result + (supportingAccessPoint?.hashCode() ?: 0)
        result = 31 * result + (transformationConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectLambdaConfiguration

        if (allowedFeatures != other.allowedFeatures) return false
        if (cloudWatchMetricsEnabled != other.cloudWatchMetricsEnabled) return false
        if (supportingAccessPoint != other.supportingAccessPoint) return false
        if (transformationConfigurations != other.transformationConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ObjectLambdaConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for allowed features. Valid inputs are `GetObject-Range`, `GetObject-PartNumber`, `HeadObject-Range`, and `HeadObject-PartNumber`.
         */
        public var allowedFeatures: List<ObjectLambdaAllowedFeature>? = null
        /**
         * A container for whether the CloudWatch metrics configuration is enabled.
         */
        public var cloudWatchMetricsEnabled: kotlin.Boolean = false
        /**
         * Standard access point associated with the Object Lambda Access Point.
         */
        public var supportingAccessPoint: kotlin.String? = null
        /**
         * A container for transformation configurations for an Object Lambda Access Point.
         */
        public var transformationConfigurations: List<ObjectLambdaTransformationConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ObjectLambdaConfiguration) : this() {
            this.allowedFeatures = x.allowedFeatures
            this.cloudWatchMetricsEnabled = x.cloudWatchMetricsEnabled
            this.supportingAccessPoint = x.supportingAccessPoint
            this.transformationConfigurations = x.transformationConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ObjectLambdaConfiguration = ObjectLambdaConfiguration(this)
    }
}
