// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A structure for a Multi-Region Access Point that indicates where Amazon S3 traffic can be routed. Routes can be either active or passive. Active routes can process Amazon S3 requests through the Multi-Region Access Point, but passive routes are not eligible to process Amazon S3 requests.
 *
 * Each route contains the Amazon S3 bucket name and the Amazon Web Services Region that the bucket is located in. The route also includes the `TrafficDialPercentage` value, which shows whether the bucket and Region are active (indicated by a value of `100`) or passive (indicated by a value of `0`).
 */
public class MultiRegionAccessPointRoute private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket for which you'll submit a routing configuration change. Either the `Bucket` or the `Region` value must be provided. If both are provided, the bucket must be in the specified Region.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon Web Services Region to which you'll be submitting a routing configuration change. Either the `Bucket` or the `Region` value must be provided. If both are provided, the bucket must be in the specified Region.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The traffic state for the specified bucket or Amazon Web Services Region.
     *
     * A value of `0` indicates a passive state, which means that no new traffic will be routed to the Region.
     *
     * A value of `100` indicates an active state, which means that traffic will be routed to the specified Region.
     *
     * When the routing configuration for a Region is changed from active to passive, any in-progress operations (uploads, copies, deletes, and so on) to the formerly active Region will continue to run to until a final success or failure status is reached.
     *
     * If all Regions in the routing configuration are designated as passive, you'll receive an `InvalidRequest` error.
     */
    public val trafficDialPercentage: kotlin.Int? = builder.trafficDialPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointRoute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MultiRegionAccessPointRoute(")
        append("bucket=$bucket,")
        append("region=$region,")
        append("trafficDialPercentage=$trafficDialPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (trafficDialPercentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MultiRegionAccessPointRoute

        if (bucket != other.bucket) return false
        if (region != other.region) return false
        if (trafficDialPercentage != other.trafficDialPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointRoute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon S3 bucket for which you'll submit a routing configuration change. Either the `Bucket` or the `Region` value must be provided. If both are provided, the bucket must be in the specified Region.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services Region to which you'll be submitting a routing configuration change. Either the `Bucket` or the `Region` value must be provided. If both are provided, the bucket must be in the specified Region.
         */
        public var region: kotlin.String? = null
        /**
         * The traffic state for the specified bucket or Amazon Web Services Region.
         *
         * A value of `0` indicates a passive state, which means that no new traffic will be routed to the Region.
         *
         * A value of `100` indicates an active state, which means that traffic will be routed to the specified Region.
         *
         * When the routing configuration for a Region is changed from active to passive, any in-progress operations (uploads, copies, deletes, and so on) to the formerly active Region will continue to run to until a final success or failure status is reached.
         *
         * If all Regions in the routing configuration are designated as passive, you'll receive an `InvalidRequest` error.
         */
        public var trafficDialPercentage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointRoute) : this() {
            this.bucket = x.bucket
            this.region = x.region
            this.trafficDialPercentage = x.trafficDialPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.MultiRegionAccessPointRoute = MultiRegionAccessPointRoute(this)
    }
}
