// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.endpoints.internal

import aws.sdk.kotlin.services.s3control.S3ControlClient
import aws.sdk.kotlin.services.s3control.endpoints.EndpointParameters
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.CreateBucketRequest
import aws.sdk.kotlin.services.s3control.model.CreateJobRequest
import aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeletePublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DescribeJobRequest
import aws.sdk.kotlin.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.GetJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.GetPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListJobsRequest
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.PutJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobPriorityRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusRequest
import aws.smithy.kotlin.runtime.auth.awssigning.mergeInto
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.signingContext
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: S3ControlClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = EndpointParameters {
            bindAwsBuiltins(config)
            val opName = request.context[SdkClientOption.OperationName]
            opContextBindings[opName]?.invoke(this, request)
        }
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        endpoint.signingContext?.mergeInto(request.context)
        return endpoint
    }
}

private typealias BindOperationContextParamsFn = (EndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "CreateAccessPoint" to ::bindCreateAccessPointEndpointContext,
    "CreateAccessPointForObjectLambda" to ::bindCreateAccessPointForObjectLambdaEndpointContext,
    "CreateBucket" to ::bindCreateBucketEndpointContext,
    "CreateJob" to ::bindCreateJobEndpointContext,
    "CreateMultiRegionAccessPoint" to ::bindCreateMultiRegionAccessPointEndpointContext,
    "DeleteAccessPoint" to ::bindDeleteAccessPointEndpointContext,
    "DeleteAccessPointForObjectLambda" to ::bindDeleteAccessPointForObjectLambdaEndpointContext,
    "DeleteAccessPointPolicy" to ::bindDeleteAccessPointPolicyEndpointContext,
    "DeleteAccessPointPolicyForObjectLambda" to ::bindDeleteAccessPointPolicyForObjectLambdaEndpointContext,
    "DeleteBucket" to ::bindDeleteBucketEndpointContext,
    "DeleteBucketLifecycleConfiguration" to ::bindDeleteBucketLifecycleConfigurationEndpointContext,
    "DeleteBucketPolicy" to ::bindDeleteBucketPolicyEndpointContext,
    "DeleteBucketReplication" to ::bindDeleteBucketReplicationEndpointContext,
    "DeleteBucketTagging" to ::bindDeleteBucketTaggingEndpointContext,
    "DeleteJobTagging" to ::bindDeleteJobTaggingEndpointContext,
    "DeleteMultiRegionAccessPoint" to ::bindDeleteMultiRegionAccessPointEndpointContext,
    "DeletePublicAccessBlock" to ::bindDeletePublicAccessBlockEndpointContext,
    "DeleteStorageLensConfiguration" to ::bindDeleteStorageLensConfigurationEndpointContext,
    "DeleteStorageLensConfigurationTagging" to ::bindDeleteStorageLensConfigurationTaggingEndpointContext,
    "DescribeJob" to ::bindDescribeJobEndpointContext,
    "DescribeMultiRegionAccessPointOperation" to ::bindDescribeMultiRegionAccessPointOperationEndpointContext,
    "GetAccessPoint" to ::bindGetAccessPointEndpointContext,
    "GetAccessPointConfigurationForObjectLambda" to ::bindGetAccessPointConfigurationForObjectLambdaEndpointContext,
    "GetAccessPointForObjectLambda" to ::bindGetAccessPointForObjectLambdaEndpointContext,
    "GetAccessPointPolicy" to ::bindGetAccessPointPolicyEndpointContext,
    "GetAccessPointPolicyForObjectLambda" to ::bindGetAccessPointPolicyForObjectLambdaEndpointContext,
    "GetAccessPointPolicyStatus" to ::bindGetAccessPointPolicyStatusEndpointContext,
    "GetAccessPointPolicyStatusForObjectLambda" to ::bindGetAccessPointPolicyStatusForObjectLambdaEndpointContext,
    "GetBucket" to ::bindGetBucketEndpointContext,
    "GetBucketLifecycleConfiguration" to ::bindGetBucketLifecycleConfigurationEndpointContext,
    "GetBucketPolicy" to ::bindGetBucketPolicyEndpointContext,
    "GetBucketReplication" to ::bindGetBucketReplicationEndpointContext,
    "GetBucketTagging" to ::bindGetBucketTaggingEndpointContext,
    "GetBucketVersioning" to ::bindGetBucketVersioningEndpointContext,
    "GetJobTagging" to ::bindGetJobTaggingEndpointContext,
    "GetMultiRegionAccessPoint" to ::bindGetMultiRegionAccessPointEndpointContext,
    "GetMultiRegionAccessPointPolicy" to ::bindGetMultiRegionAccessPointPolicyEndpointContext,
    "GetMultiRegionAccessPointPolicyStatus" to ::bindGetMultiRegionAccessPointPolicyStatusEndpointContext,
    "GetMultiRegionAccessPointRoutes" to ::bindGetMultiRegionAccessPointRoutesEndpointContext,
    "GetPublicAccessBlock" to ::bindGetPublicAccessBlockEndpointContext,
    "GetStorageLensConfiguration" to ::bindGetStorageLensConfigurationEndpointContext,
    "GetStorageLensConfigurationTagging" to ::bindGetStorageLensConfigurationTaggingEndpointContext,
    "ListAccessPoints" to ::bindListAccessPointsEndpointContext,
    "ListAccessPointsForObjectLambda" to ::bindListAccessPointsForObjectLambdaEndpointContext,
    "ListJobs" to ::bindListJobsEndpointContext,
    "ListMultiRegionAccessPoints" to ::bindListMultiRegionAccessPointsEndpointContext,
    "ListRegionalBuckets" to ::bindListRegionalBucketsEndpointContext,
    "ListStorageLensConfigurations" to ::bindListStorageLensConfigurationsEndpointContext,
    "PutAccessPointConfigurationForObjectLambda" to ::bindPutAccessPointConfigurationForObjectLambdaEndpointContext,
    "PutAccessPointPolicy" to ::bindPutAccessPointPolicyEndpointContext,
    "PutAccessPointPolicyForObjectLambda" to ::bindPutAccessPointPolicyForObjectLambdaEndpointContext,
    "PutBucketLifecycleConfiguration" to ::bindPutBucketLifecycleConfigurationEndpointContext,
    "PutBucketPolicy" to ::bindPutBucketPolicyEndpointContext,
    "PutBucketReplication" to ::bindPutBucketReplicationEndpointContext,
    "PutBucketTagging" to ::bindPutBucketTaggingEndpointContext,
    "PutBucketVersioning" to ::bindPutBucketVersioningEndpointContext,
    "PutJobTagging" to ::bindPutJobTaggingEndpointContext,
    "PutMultiRegionAccessPointPolicy" to ::bindPutMultiRegionAccessPointPolicyEndpointContext,
    "PutPublicAccessBlock" to ::bindPutPublicAccessBlockEndpointContext,
    "PutStorageLensConfiguration" to ::bindPutStorageLensConfigurationEndpointContext,
    "PutStorageLensConfigurationTagging" to ::bindPutStorageLensConfigurationTaggingEndpointContext,
    "SubmitMultiRegionAccessPointRoutes" to ::bindSubmitMultiRegionAccessPointRoutesEndpointContext,
    "UpdateJobPriority" to ::bindUpdateJobPriorityEndpointContext,
    "UpdateJobStatus" to ::bindUpdateJobStatusEndpointContext,
)

private fun EndpointParameters.Builder.bindAwsBuiltins(config: S3ControlClient.Config) {
    region = config.region
    useFips = config.useFips
    useDualStack = config.useDualStack
    endpoint = config.endpointUrl?.toString()
    useArnRegion = config.useArnRegion
}

private fun bindCreateAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindCreateAccessPointForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateBucketEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateBucketRequest
    builder.outpostId = input.outpostId
    builder.bucket = input.bucket
}

private fun bindCreateJobEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateJobRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindCreateMultiRegionAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindDeleteAccessPointForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteAccessPointPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindDeleteAccessPointPolicyForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteBucketEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketLifecycleConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketReplicationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteBucketTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindDeleteJobTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteMultiRegionAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeletePublicAccessBlockEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeletePublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteStorageLensConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDeleteStorageLensConfigurationTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDescribeJobEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeJobRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindDescribeMultiRegionAccessPointOperationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeMultiRegionAccessPointOperationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointConfigurationForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointConfigurationForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointPolicyForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetAccessPointPolicyStatusEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindGetAccessPointPolicyStatusForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetAccessPointPolicyStatusForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetBucketEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketLifecycleConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketReplicationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetBucketVersioningEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketVersioningRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindGetJobTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointPolicyStatusEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointPolicyStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetMultiRegionAccessPointRoutesEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetMultiRegionAccessPointRoutesRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetPublicAccessBlockEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetPublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetStorageLensConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindGetStorageLensConfigurationTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListAccessPointsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessPointsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindListAccessPointsForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListAccessPointsForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListJobsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListJobsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListMultiRegionAccessPointsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListMultiRegionAccessPointsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindListRegionalBucketsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListRegionalBucketsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.outpostId = input.outpostId
}

private fun bindListStorageLensConfigurationsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListStorageLensConfigurationsRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutAccessPointConfigurationForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointConfigurationForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutAccessPointPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.accessPointName = input.name
}

private fun bindPutAccessPointPolicyForObjectLambdaEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutAccessPointPolicyForObjectLambdaRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutBucketLifecycleConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketLifecycleConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketReplicationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketReplicationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutBucketVersioningEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketVersioningRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
    builder.bucket = input.bucket
}

private fun bindPutJobTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutJobTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutMultiRegionAccessPointPolicyEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutMultiRegionAccessPointPolicyRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutPublicAccessBlockEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutPublicAccessBlockRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutStorageLensConfigurationEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutStorageLensConfigurationRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindPutStorageLensConfigurationTaggingEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutStorageLensConfigurationTaggingRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindSubmitMultiRegionAccessPointRoutesEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SubmitMultiRegionAccessPointRoutesRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateJobPriorityEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateJobPriorityRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}

private fun bindUpdateJobStatusEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateJobStatusRequest
    builder.accountId = input.accountId
    builder.requiresAccountId = true
}
