// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.endpoints

import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.smithy.kotlin.runtime.http.Headers
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.util.Attributes
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // Vanilla outposts without ARN region + access point ARN@us-west-2
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Vanilla outposts with ARN region + access point ARN@us-west-2
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // accept an access point ARN@us-west-2
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // vanilla outposts china@cn-north-1
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.cn-north-1.amazonaws.com.cn"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov region@us-west-2
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov cloud with fips@us-west-2
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // govcloud with fips + arn region@us-gov-west-1
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov region@cn-north-1
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.cn-north-1.amazonaws.com.cn"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov cloud with fips@cn-north-1
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.cn-north-1.amazonaws.com.cn"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // govcloud with fips + arn region@us-gov-west-1
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov region@af-south-1
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "af-south-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.af-south-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "af-south-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // gov cloud with fips@af-south-1
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "af-south-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.af-south-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "af-south-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // govcloud with fips + arn region@us-gov-west-1
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // CreateBucket + OutpostId = outposts endpoint@us-east-2
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            bucket = "blah"
            outpostId = "123"
            region = "us-east-2"
            requiresAccountId = false
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // CreateBucket + OutpostId with fips = outposts endpoint@us-east-2
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            bucket = "blah"
            outpostId = "123"
            region = "us-east-2"
            requiresAccountId = false
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // CreateBucket without OutpostId = regular endpoint@us-east-2
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            bucket = "blah"
            region = "us-east-2"
            requiresAccountId = false
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // ListRegionalBuckets + OutpostId = outposts endpoint@us-east-2
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            accountId = "123"
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // ListRegionalBuckets without OutpostId = regular endpoint@us-east-2
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            accountId = "123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://123.s3-control.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // ListRegionalBucket + OutpostId with fips = outposts endpoint@us-east-2
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            accountId = "123"
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-east-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // outpost access points do not support dualstack@us-west-2
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost Access Points do not support dual-stack", ex.message)
    }

    // outpost access points do not support dualstack@cn-north-1
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost Access Points do not support dual-stack", ex.message)
    }

    // outpost access points do not support dualstack@af-south-1
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "af-south-1"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost Access Points do not support dual-stack", ex.message)
    }

    // invalid ARN: must be include outpost ID@us-west-2
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: The Outpost Id was not set", ex.message)
    }

    // invalid ARN: must specify access point@us-west-2
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: Expected a 4-component resource", ex.message)
    }

    // invalid ARN@us-west-2
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:myaccesspoint"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: Expected a 4-component resource", ex.message)
    }

    // when set, AccountId drives AP construction@us-west-2
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            accessPointName = "myaccesspoint"
            accountId = "myid-1234"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://myid-1234.s3-control.us-west-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Account ID set inline and in ARN but they both match@us-west-2
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useArnRegion = false
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Account ID set inline and in ARN and they do not match@us-west-2
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "9999999"
            region = "us-west-2"
            requiresAccountId = true
            useArnRegion = false
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: the accountId specified in the ARN (`123456789012`) does not match the parameter (`9999999`)", ex.message)
    }

    // get access point prefixed with account id using endpoint url@us-west-2
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            accessPointName = "apname"
            accountId = "123456789012"
            endpoint = "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://123456789012.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // endpoint url with s3-outposts@us-west-2
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // access point name with a bucket arn@us-west-2
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            endpoint = "beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Expected an outpost type `accesspoint`, found `bucket`", ex.message)
    }

    // bucket arn with access point name@us-west-2
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            endpoint = "beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: Expected an outpost type `bucket`, found `accesspoint`", ex.message)
    }

    // create bucket with outposts@us-west-2
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            bucket = "bucketname"
            endpoint = "https://beta.example.com"
            outpostId = "op-123"
            region = "us-west-2"
            requiresAccountId = false
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // get bucket with endpoint_url@us-west-2
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // ListRegionalBucket + OutpostId endpoint url@us-east-2
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            accountId = "123"
            endpoint = "https://beta.example.com"
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // ListRegionalBucket + OutpostId + fips + endpoint url@us-east-2
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            accountId = "123"
            endpoint = "https://beta.example.com"
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // CreateBucket + OutpostId endpoint url@us-east-2
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            bucket = "blah"
            endpoint = "https://beta.example.com"
            outpostId = "123"
            region = "us-east-2"
            requiresAccountId = false
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // dualstack cannot be used with outposts when an endpoint URL is set@us-west-2.
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost Access Points do not support dual-stack", ex.message)
    }

    // Dual-stack cannot be used with outposts@us-west-2
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            bucket = "bucketname"
            endpoint = "https://beta.example.com"
            outpostId = "op-123"
            region = "us-west-2"
            requiresAccountId = false
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outposts do not support dual-stack", ex.message)
    }

    // vanilla bucket arn requires account id@us-west-2
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket arn with UseArnRegion = true (arn region supercedes client configured region)@us-west-2
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition (non-fips)@us-gov-east-1
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition with FIPS@us-gov-west-1
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-west-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in aws partition with FIPS@us-east-2
    @Test
    fun test43() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-east-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Outposts do not support dualstack@us-west-2
    @Test
    fun test44() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost buckets do not support dual-stack", ex.message)
    }

    // vanilla bucket arn requires account id@cn-north-1
    @Test
    fun test45() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.cn-north-1.amazonaws.com.cn"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket arn with UseArnRegion = true (arn region supercedes client configured region)@us-west-2
    @Test
    fun test46() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition (non-fips)@us-gov-east-1
    @Test
    fun test47() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition with FIPS@us-gov-west-1
    @Test
    fun test48() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-west-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in aws partition with FIPS@us-east-2
    @Test
    fun test49() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-east-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Outposts do not support dualstack@us-west-2
    @Test
    fun test50() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost buckets do not support dual-stack", ex.message)
    }

    // vanilla bucket arn requires account id@af-south-1
    @Test
    fun test51() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "af-south-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.af-south-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "af-south-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket arn with UseArnRegion = true (arn region supercedes client configured region)@us-west-2
    @Test
    fun test52() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition (non-fips)@us-gov-east-1
    @Test
    fun test53() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-gov-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in gov partition with FIPS@us-gov-west-1
    @Test
    fun test54() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-gov-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-gov-west-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // bucket ARN in aws partition with FIPS@us-east-2
    @Test
    fun test55() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts-fips.us-east-2.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Outposts do not support dualstack@us-west-2
    @Test
    fun test56() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost buckets do not support dual-stack", ex.message)
    }

    // Invalid ARN: missing outpost id and bucket@us-west-2
    @Test
    fun test57() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: The Outpost Id was not set", ex.message)
    }

    // Invalid ARN: missing bucket@us-west-2
    @Test
    fun test58() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: Expected a 4-component resource", ex.message)
    }

    // Invalid ARN: missing outpost and bucket ids@us-west-2
    @Test
    fun test59() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:bucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: Expected a 4-component resource", ex.message)
    }

    // Invalid ARN: missing bucket id@us-west-2
    @Test
    fun test60() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: expected a bucket name", ex.message)
    }

    // account id inserted into hostname@us-west-2
    @Test
    fun test61() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890.s3-control.us-west-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // account id prefix with dualstack@us-east-1
    @Test
    fun test62() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890.s3-control.dualstack.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // account id prefix with fips@us-east-1
    @Test
    fun test63() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890.s3-control-fips.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom account id prefix with fips@us-east-1
    @Test
    fun test64() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.s3-control-fips.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // standard url @ us-east-1
    @Test
    fun test65() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // fips url @ us-east-1
    @Test
    fun test66() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control-fips.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // dualstack url @ us-east-1
    @Test
    fun test67() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control.dualstack.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // fips,dualstack url @ us-east-1
    @Test
    fun test68() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control-fips.dualstack.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // standard url @ cn-north-1
    @Test
    fun test69() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-control.cn-north-1.amazonaws.com.cn"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // fips @ cn-north-1
    @Test
    fun test70() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = true
            useFips = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Partition does not support FIPS", ex.message)
    }

    // custom account id prefix @us-east-1
    @Test
    fun test71() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.s3-control.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // invalid account id prefix @us-east-1
    @Test
    fun test72() = runTest {
        val params = EndpointParameters {
            accountId = "/?invalid&not-host*label"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId must only contain a-z, A-Z, 0-9 and `-`.", ex.message)
    }

    // custom account id prefix with fips@us-east-1
    @Test
    fun test73() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.s3-control-fips.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom account id prefix with dualstack,fips@us-east-1
    @Test
    fun test74() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.s3-control-fips.dualstack.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom account id with custom endpoint
    @Test
    fun test75() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // RequiresAccountId with AccountId unset
    @Test
    fun test76() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            requiresAccountId = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId is required but not set", ex.message)
    }

    // RequiresAccountId with AccountId unset and custom endpoint
    @Test
    fun test77() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            endpoint = "https://beta.example.com"
            requiresAccountId = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId is required but not set", ex.message)
    }

    // RequiresAccountId with invalid AccountId and custom endpoint
    @Test
    fun test78() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            endpoint = "https://beta.example.com"
            accountId = "/?invalid&not-host*label"
            requiresAccountId = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId must only contain a-z, A-Z, 0-9 and `-`.", ex.message)
    }

    // account id with custom endpoint, fips and dualstack
    @Test
    fun test79() = runTest {
        val params = EndpointParameters {
            accountId = "1234567890-aBC"
            region = "us-east-1"
            requiresAccountId = true
            endpoint = "https://example.com"
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://1234567890-aBC.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom endpoint, fips and dualstack
    @Test
    fun test80() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            endpoint = "https://example.com"
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom endpoint, fips
    @Test
    fun test81() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            endpoint = "https://example.com"
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // custom endpoint, dualstack
    @Test
    fun test82() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            endpoint = "https://example.com"
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // region not set
    @Test
    fun test83() = runTest {
        val params = EndpointParameters {
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Region must be set", ex.message)
    }

    // invalid partition
    @Test
    fun test84() = runTest {
        val params = EndpointParameters {
            region = "invalid-region 42"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid region: region was not a valid DNS name.", ex.message)
    }

    // ListRegionalBuckets + OutpostId without accountId set.
    @Test
    fun test85() = runTest {
        val params = EndpointParameters {
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId is required but not set", ex.message)
    }

    // ListRegionalBuckets + OutpostId with invalid accountId set.
    @Test
    fun test86() = runTest {
        val params = EndpointParameters {
            accountId = "/?invalid&not-host*label"
            outpostId = "op-123"
            region = "us-east-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId must only contain a-z, A-Z, 0-9 and `-`.", ex.message)
    }

    // accesspoint set but missing accountId
    @Test
    fun test87() = runTest {
        val params = EndpointParameters {
            accessPointName = "myaccesspoint"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("AccountId is required but not set", ex.message)
    }

    // outpost accesspoint ARN with missing accountId
    @Test
    fun test88() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2::outpost:op-01234567890123456:outpost:op1"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: missing account ID", ex.message)
    }

    // bucket ARN with missing accountId
    @Test
    fun test89() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2::outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: missing account ID", ex.message)
    }

    // endpoint url with accesspoint (non-arn)
    @Test
    fun test90() = runTest {
        val params = EndpointParameters {
            accessPointName = "apname"
            endpoint = "https://beta.example.com"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://123456789012.beta.example.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // access point name with an accesspoint arn@us-west-2
    @Test
    fun test91() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://beta.example.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Dualstack + Custom endpoint is not supported(non-arn)
    @Test
    fun test92() = runTest {
        val params = EndpointParameters {
            accessPointName = "apname"
            endpoint = "https://beta.example.com"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

    // get bucket with endpoint_url and dualstack is not supported@us-west-2
    @Test
    fun test93() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: Outpost buckets do not support dual-stack", ex.message)
    }

    // ListRegionalBuckets + OutpostId with fips in CN.
    @Test
    fun test94() = runTest {
        val params = EndpointParameters {
            accountId = "0123456789012"
            outpostId = "op-123"
            region = "cn-north-1"
            requiresAccountId = true
            useDualStack = false
            useFips = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Partition does not support FIPS", ex.message)
    }

    // ListRegionalBuckets + invalid OutpostId.
    @Test
    fun test95() = runTest {
        val params = EndpointParameters {
            accountId = "0123456789012"
            outpostId = "?outpost/invalid+"
            region = "us-west-1"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("OutpostId must only contain a-z, A-Z, 0-9 and `-`.", ex.message)
    }

    // bucket ARN with mismatched accountId
    @Test
    fun test96() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-west-2:999999:outpost:op-01234567890123456:bucket:mybucket"
            accountId = "0123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid ARN: the accountId specified in the ARN (`999999`) does not match the parameter (`0123456789012`)", ex.message)
    }

    // OutpostId with invalid region
    @Test
    fun test97() = runTest {
        val params = EndpointParameters {
            outpostId = "op-123"
            region = "invalid-region 42"
            accountId = "0123456"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid region: region was not a valid DNS name.", ex.message)
    }

    // OutpostId with RequireAccountId unset
    @Test
    fun test98() = runTest {
        val params = EndpointParameters {
            outpostId = "op-123"
            region = "us-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-west-2.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-west-2",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Outpost Accesspoint ARN with arn region and client region mismatch with UseArnRegion=false
    @Test
    fun test99() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useArnRegion = false
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", ex.message)
    }

    // Outpost Bucket ARN with arn region and client region mismatch with UseArnRegion=false
    @Test
    fun test100() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            endpoint = "https://beta.example.com"
            region = "us-west-2"
            requiresAccountId = true
            useArnRegion = false
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", ex.message)
    }

    // Accesspoint ARN with region mismatch and UseArnRegion unset
    @Test
    fun test101() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Bucket ARN with region mismatch and UseArnRegion unset
    @Test
    fun test102() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://s3-outposts.us-east-1.amazonaws.com"),
            headers = Headers {
                append("x-amz-account-id", "123456789012")
                append("x-amz-outpost-id", "op-01234567890123456")
            },
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "s3-outposts",
                            disableDoubleEncoding = true,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // Outpost Bucket ARN with partition mismatch with UseArnRegion=true
    @Test
    fun test103() = runTest {
        val params = EndpointParameters {
            bucket = "arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"
            region = "us-west-2"
            requiresAccountId = true
            useArnRegion = true
            useDualStack = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Client was configured for partition `aws` but ARN has `aws-cn`", ex.message)
    }

    // Accesspoint ARN with partition mismatch and UseArnRegion=true
    @Test
    fun test104() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            accountId = "123456789012"
            region = "us-west-2"
            requiresAccountId = true
            useDualStack = false
            useArnRegion = true
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Client was configured for partition `aws` but ARN has `aws-cn`", ex.message)
    }

    // Accesspoint ARN with region mismatch, UseArnRegion=false and custom endpoint
    @Test
    fun test105() = runTest {
        val params = EndpointParameters {
            accessPointName = "arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"
            region = "us-west-2"
            endpoint = "https://example.com"
            requiresAccountId = true
            useDualStack = false
            useArnRegion = false
            useFips = false
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid configuration: region from ARN `cn-north-1` does not match client region `us-west-2` and UseArnRegion is `false`", ex.message)
    }

}
