// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.sdk.kotlin.services.s3control.model.StorageLensConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class GetStorageLensConfigurationOperationDeserializer: HttpDeserialize<GetStorageLensConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetStorageLensConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetStorageLensConfigurationError(context, response)
        }
        val builder = GetStorageLensConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.storageLensConfiguration = deserializeStorageLensConfigurationPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwGetStorageLensConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
