// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.s3control.model.BucketVersioningStatus
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningResponse
import aws.sdk.kotlin.services.s3control.model.MfaDeleteStatus
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetBucketVersioningOperationDeserializer: HttpDeserialize<GetBucketVersioningResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBucketVersioningResponse {
        if (!response.status.isSuccess()) {
            throwGetBucketVersioningError(context, response)
        }
        val builder = GetBucketVersioningResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBucketVersioningOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBucketVersioningError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketVersioningOperationBody(builder: GetBucketVersioningResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val MFADELETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("MfaDelete"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetBucketVersioningResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(MFADELETE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MFADELETE_DESCRIPTOR.index -> builder.mfaDelete = deserializeString().let { MfaDeleteStatus.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { BucketVersioningStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
