// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the S3 Object Lock retention mode to be applied to all objects in the S3 Batch Operations job. If you don't provide `Mode` and `RetainUntilDate` data types in your operation, you will remove the retention from your objects. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
 */
public class S3Retention private constructor(builder: Builder) {
    /**
     * The Object Lock retention mode to be applied to all objects in the Batch Operations job.
     */
    public val mode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockRetentionMode? = builder.mode
    /**
     * The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.
     */
    public val retainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = builder.retainUntilDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3Retention = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Retention(")
        append("mode=$mode,")
        append("retainUntilDate=$retainUntilDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mode?.hashCode() ?: 0
        result = 31 * result + (retainUntilDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Retention

        if (mode != other.mode) return false
        if (retainUntilDate != other.retainUntilDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3Retention = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Object Lock retention mode to be applied to all objects in the Batch Operations job.
         */
        public var mode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockRetentionMode? = null
        /**
         * The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.
         */
        public var retainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3Retention) : this() {
            this.mode = x.mode
            this.retainUntilDate = x.retainUntilDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3Retention = S3Retention(this)
    }
}
