// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container for the information associated with a [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html) request.
 */
public class CreateMultiRegionAccessPointInput private constructor(builder: Builder) {
    /**
     * The name of the Multi-Region Access Point associated with this request.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
     *
     * This data type is not supported for Amazon S3 on Outposts.
     */
    public val publicAccessBlock: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = builder.publicAccessBlock
    /**
     * The buckets in different Regions that are associated with the Multi-Region Access Point.
     */
    public val regions: List<Region>? = builder.regions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMultiRegionAccessPointInput(")
        append("name=$name,")
        append("publicAccessBlock=$publicAccessBlock,")
        append("regions=$regions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (publicAccessBlock?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMultiRegionAccessPointInput

        if (name != other.name) return false
        if (publicAccessBlock != other.publicAccessBlock) return false
        if (regions != other.regions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Multi-Region Access Point associated with this request.
         */
        public var name: kotlin.String? = null
        /**
         * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
         *
         * This data type is not supported for Amazon S3 on Outposts.
         */
        public var publicAccessBlock: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = null
        /**
         * The buckets in different Regions that are associated with the Multi-Region Access Point.
         */
        public var regions: List<Region>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointInput) : this() {
            this.name = x.name
            this.publicAccessBlock = x.publicAccessBlock
            this.regions = x.regions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointInput = CreateMultiRegionAccessPointInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun publicAccessBlock(block: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlock = aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.invoke(block)
        }
    }
}
