// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.JobStatus
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class UpdateJobStatusOperationDeserializer: HttpDeserializer.NonStreaming<UpdateJobStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateJobStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateJobStatusError(context, call, payload)
        }
        val builder = UpdateJobStatusResponse.Builder()

        if (payload != null) {
            deserializeUpdateJobStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateJobStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "JobStatusException" -> JobStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateJobStatusOperationBody(builder: UpdateJobStatusResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // JobId com.amazonaws.s3control#UpdateJobStatusResult$JobId
            "JobId" -> builder.jobId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobId`)" }
            // Status com.amazonaws.s3control#UpdateJobStatusResult$Status
            "Status" -> builder.status = curr.tryData()
                .parse { JobStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#JobStatus`)" }
            // StatusUpdateReason com.amazonaws.s3control#UpdateJobStatusResult$StatusUpdateReason
            "StatusUpdateReason" -> builder.statusUpdateReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#JobStatusUpdateReason`)" }
            else -> {}
        }
        curr.drop()
    }
}
