// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateAccessGrantsLocationOperationDeserializer: HttpDeserializer.NonStreaming<UpdateAccessGrantsLocationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateAccessGrantsLocationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateAccessGrantsLocationError(context, call, payload)
        }
        val builder = UpdateAccessGrantsLocationResponse.Builder()

        if (payload != null) {
            deserializeUpdateAccessGrantsLocationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateAccessGrantsLocationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateAccessGrantsLocationOperationBody(builder: UpdateAccessGrantsLocationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessGrantsLocationArn com.amazonaws.s3control#UpdateAccessGrantsLocationResult$AccessGrantsLocationArn
            "AccessGrantsLocationArn" -> builder.accessGrantsLocationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsLocationArn`)" }
            // AccessGrantsLocationId com.amazonaws.s3control#UpdateAccessGrantsLocationResult$AccessGrantsLocationId
            "AccessGrantsLocationId" -> builder.accessGrantsLocationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsLocationId`)" }
            // CreatedAt com.amazonaws.s3control#UpdateAccessGrantsLocationResult$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // IAMRoleArn com.amazonaws.s3control#UpdateAccessGrantsLocationResult$IAMRoleArn
            "IAMRoleArn" -> builder.iamRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IAMRoleArn`)" }
            // LocationScope com.amazonaws.s3control#UpdateAccessGrantsLocationResult$LocationScope
            "LocationScope" -> builder.locationScope = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3Prefix`)" }
            else -> {}
        }
        curr.drop()
    }
}
