// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupEntry
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListStorageLensGroupsOperationDeserializer: HttpDeserializer.NonStreaming<ListStorageLensGroupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListStorageLensGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListStorageLensGroupsError(context, call, payload)
        }
        val builder = ListStorageLensGroupsResponse.Builder()

        if (payload != null) {
            deserializeListStorageLensGroupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListStorageLensGroupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListStorageLensGroupsOperationBody(builder: ListStorageLensGroupsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextToken com.amazonaws.s3control#ListStorageLensGroupsResult$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ContinuationToken`)" }
            // StorageLensGroupList com.amazonaws.s3control#ListStorageLensGroupsResult$StorageLensGroupList
            "StorageLensGroup" -> builder.storageLensGroupList = run {
                val el = deserializeListStorageLensGroupEntryDocument(curr)
                createOrAppend(builder.storageLensGroupList, el)
            }
            else -> {}
        }
        curr.drop()
    }
}
