// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.JobReport
import aws.sdk.kotlin.services.s3control.model.JobReportFormat
import aws.sdk.kotlin.services.s3control.model.JobReportScope
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeJobReportDocument(reader: XmlTagReader): JobReport {
    val builder = JobReport.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3control#JobReport$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3BucketArnString`)" }
            // Format com.amazonaws.s3control#JobReport$Format
            "Format" -> builder.format = curr.tryData()
                .parse { JobReportFormat.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#JobReportFormat`)" }
            // Enabled com.amazonaws.s3control#JobReport$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3control#Boolean`)" }
            // Prefix com.amazonaws.s3control#JobReport$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ReportPrefixString`)" }
            // ReportScope com.amazonaws.s3control#JobReport$ReportScope
            "ReportScope" -> builder.reportScope = curr.tryData()
                .parse { JobReportScope.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#JobReportScope`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
