// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.CreateJobRequest
import aws.sdk.kotlin.services.s3control.model.JobManifest
import aws.sdk.kotlin.services.s3control.model.JobManifestGenerator
import aws.sdk.kotlin.services.s3control.model.JobOperation
import aws.sdk.kotlin.services.s3control.model.JobReport
import aws.sdk.kotlin.services.s3control.model.S3Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateJobOperationSerializer: HttpSerializer.NonStreaming<CreateJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/v20180820/jobs"
        }

        builder.headers {
            if (input.accountId != null) append("x-amz-account-id", input.accountId)
        }

        val payload = serializeCreateJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeCreateJobOperationBody(context: ExecutionContext, input: CreateJobRequest): ByteArray {
    val serializer = XmlSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClientRequestToken"))
    val CONFIRMATIONREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("ConfirmationRequired"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val MANIFEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Manifest"))
    val MANIFESTGENERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ManifestGenerator"))
    val OPERATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Operation"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("Priority"))
    val REPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Report"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("RoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateJobRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CONFIRMATIONREQUIRED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(MANIFEST_DESCRIPTOR)
        field(MANIFESTGENERATOR_DESCRIPTOR)
        field(OPERATION_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(REPORT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.confirmationRequired?.let { field(CONFIRMATIONREQUIRED_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.manifest?.let { field(MANIFEST_DESCRIPTOR, it, ::serializeJobManifestDocument) }
        input.manifestGenerator?.let { field(MANIFESTGENERATOR_DESCRIPTOR, it, ::serializeJobManifestGeneratorDocument) }
        input.operation?.let { field(OPERATION_DESCRIPTOR, it, ::serializeJobOperationDocument) }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        input.report?.let { field(REPORT_DESCRIPTOR, it, ::serializeJobReportDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeS3TagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
