// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.BucketCannedAcl
import aws.sdk.kotlin.services.s3control.model.CreateBucketConfiguration
import aws.sdk.kotlin.services.s3control.model.CreateBucketRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateBucketOperationSerializer: HttpSerializer.NonStreaming<CreateBucketRequest> {
    override fun serialize(context: ExecutionContext, input: CreateBucketRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.bucket) { "bucket is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("bucket"))
                add(PercentEncoding.SmithyLabel.encode(input.bucket))
            }
        }

        builder.headers {
            if (input.acl != null) append("x-amz-acl", input.acl.value)
            if (input.grantFullControl != null) append("x-amz-grant-full-control", input.grantFullControl)
            if (input.grantRead != null) append("x-amz-grant-read", input.grantRead)
            if (input.grantReadAcp != null) append("x-amz-grant-read-acp", input.grantReadAcp)
            if (input.grantWrite != null) append("x-amz-grant-write", input.grantWrite)
            if (input.grantWriteAcp != null) append("x-amz-grant-write-acp", input.grantWriteAcp)
            if (input.objectLockEnabledForBucket != null) append("x-amz-bucket-object-lock-enabled", input.objectLockEnabledForBucket.toString())
            if (input.outpostId != null) append("x-amz-outpost-id", input.outpostId)
        }

        if (input.createBucketConfiguration != null) {
            val payload = serializeCreateBucketConfigurationPayloadWithXmlNameCreateBucketConfiguration(input.createBucketConfiguration)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
