// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.Grantee
import aws.sdk.kotlin.services.s3control.model.Permission
import aws.sdk.kotlin.services.s3control.model.S3PrefixType
import aws.sdk.kotlin.services.s3control.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateAccessGrantOperationSerializer: HttpSerializer.NonStreaming<CreateAccessGrantRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAccessGrantRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/v20180820/accessgrantsinstance/grant"
        }

        builder.headers {
            if (input.accountId != null) append("x-amz-account-id", input.accountId)
        }

        val payload = serializeCreateAccessGrantOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeCreateAccessGrantOperationBody(context: ExecutionContext, input: CreateAccessGrantRequest): ByteArray {
    val serializer = XmlSerializer()
    val ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AccessGrantsLocationConfiguration"))
    val ACCESSGRANTSLOCATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessGrantsLocationId"))
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ApplicationArn"))
    val GRANTEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Grantee"))
    val PERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Permission"))
    val S3PREFIXTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("S3PrefixType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"), XmlCollectionName("Tag"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAccessGrantRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR)
        field(ACCESSGRANTSLOCATIONID_DESCRIPTOR)
        field(APPLICATIONARN_DESCRIPTOR)
        field(GRANTEE_DESCRIPTOR)
        field(PERMISSION_DESCRIPTOR)
        field(S3PREFIXTYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessGrantsLocationConfiguration?.let { field(ACCESSGRANTSLOCATIONCONFIGURATION_DESCRIPTOR, it, ::serializeAccessGrantsLocationConfigurationDocument) }
        input.accessGrantsLocationId?.let { field(ACCESSGRANTSLOCATIONID_DESCRIPTOR, it) }
        input.applicationArn?.let { field(APPLICATIONARN_DESCRIPTOR, it) }
        input.grantee?.let { field(GRANTEE_DESCRIPTOR, it, ::serializeGranteeDocument) }
        input.permission?.let { field(PERMISSION_DESCRIPTOR, it.value) }
        input.s3PrefixType?.let { field(S3PREFIXTYPE_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
