// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for the Amazon S3 Storage Lens configuration.
 */
public class StorageLensConfiguration private constructor(builder: Builder) {
    /**
     * A container for all the account-level configurations of your S3 Storage Lens configuration.
     */
    public val accountLevel: aws.sdk.kotlin.services.s3control.model.AccountLevel? = builder.accountLevel
    /**
     * A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
     */
    public val awsOrg: aws.sdk.kotlin.services.s3control.model.StorageLensAwsOrg? = builder.awsOrg
    /**
     * A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.
     */
    public val dataExport: aws.sdk.kotlin.services.s3control.model.StorageLensDataExport? = builder.dataExport
    /**
     * A container for what is excluded in this configuration. This container can only be valid if there is no `Include` container submitted, and it's not empty.
     */
    public val exclude: aws.sdk.kotlin.services.s3control.model.Exclude? = builder.exclude
    /**
     * A container for the Amazon S3 Storage Lens configuration ID.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A container for what is included in this configuration. This container can only be valid if there is no `Exclude` container submitted, and it's not empty.
     */
    public val include: aws.sdk.kotlin.services.s3control.model.Include? = builder.include
    /**
     * A container for whether the S3 Storage Lens configuration is enabled.
     */
    public val isEnabled: kotlin.Boolean = builder.isEnabled
    /**
     * The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> `
     */
    public val storageLensArn: kotlin.String? = builder.storageLensArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.StorageLensConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageLensConfiguration(")
        append("accountLevel=$accountLevel,")
        append("awsOrg=$awsOrg,")
        append("dataExport=$dataExport,")
        append("exclude=$exclude,")
        append("id=$id,")
        append("include=$include,")
        append("isEnabled=$isEnabled,")
        append("storageLensArn=$storageLensArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountLevel?.hashCode() ?: 0
        result = 31 * result + (awsOrg?.hashCode() ?: 0)
        result = 31 * result + (dataExport?.hashCode() ?: 0)
        result = 31 * result + (exclude?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (include?.hashCode() ?: 0)
        result = 31 * result + (isEnabled.hashCode())
        result = 31 * result + (storageLensArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageLensConfiguration

        if (accountLevel != other.accountLevel) return false
        if (awsOrg != other.awsOrg) return false
        if (dataExport != other.dataExport) return false
        if (exclude != other.exclude) return false
        if (id != other.id) return false
        if (include != other.include) return false
        if (isEnabled != other.isEnabled) return false
        if (storageLensArn != other.storageLensArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.StorageLensConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A container for all the account-level configurations of your S3 Storage Lens configuration.
         */
        public var accountLevel: aws.sdk.kotlin.services.s3control.model.AccountLevel? = null
        /**
         * A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
         */
        public var awsOrg: aws.sdk.kotlin.services.s3control.model.StorageLensAwsOrg? = null
        /**
         * A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.
         */
        public var dataExport: aws.sdk.kotlin.services.s3control.model.StorageLensDataExport? = null
        /**
         * A container for what is excluded in this configuration. This container can only be valid if there is no `Include` container submitted, and it's not empty.
         */
        public var exclude: aws.sdk.kotlin.services.s3control.model.Exclude? = null
        /**
         * A container for the Amazon S3 Storage Lens configuration ID.
         */
        public var id: kotlin.String? = null
        /**
         * A container for what is included in this configuration. This container can only be valid if there is no `Exclude` container submitted, and it's not empty.
         */
        public var include: aws.sdk.kotlin.services.s3control.model.Include? = null
        /**
         * A container for whether the S3 Storage Lens configuration is enabled.
         */
        public var isEnabled: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> `
         */
        public var storageLensArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.StorageLensConfiguration) : this() {
            this.accountLevel = x.accountLevel
            this.awsOrg = x.awsOrg
            this.dataExport = x.dataExport
            this.exclude = x.exclude
            this.id = x.id
            this.include = x.include
            this.isEnabled = x.isEnabled
            this.storageLensArn = x.storageLensArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.StorageLensConfiguration = StorageLensConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AccountLevel] inside the given [block]
         */
        public fun accountLevel(block: aws.sdk.kotlin.services.s3control.model.AccountLevel.Builder.() -> kotlin.Unit) {
            this.accountLevel = aws.sdk.kotlin.services.s3control.model.AccountLevel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensAwsOrg] inside the given [block]
         */
        public fun awsOrg(block: aws.sdk.kotlin.services.s3control.model.StorageLensAwsOrg.Builder.() -> kotlin.Unit) {
            this.awsOrg = aws.sdk.kotlin.services.s3control.model.StorageLensAwsOrg.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensDataExport] inside the given [block]
         */
        public fun dataExport(block: aws.sdk.kotlin.services.s3control.model.StorageLensDataExport.Builder.() -> kotlin.Unit) {
            this.dataExport = aws.sdk.kotlin.services.s3control.model.StorageLensDataExport.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Exclude] inside the given [block]
         */
        public fun exclude(block: aws.sdk.kotlin.services.s3control.model.Exclude.Builder.() -> kotlin.Unit) {
            this.exclude = aws.sdk.kotlin.services.s3control.model.Exclude.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Include] inside the given [block]
         */
        public fun include(block: aws.sdk.kotlin.services.s3control.model.Include.Builder.() -> kotlin.Unit) {
            this.include = aws.sdk.kotlin.services.s3control.model.Include.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            return this
        }
    }
}
