// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the configuration parameters for a PUT Copy object operation. S3 Batch Operations passes every object to the underlying `CopyObject` API operation. For more information about the parameters for this operation, see [CopyObject](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
 */
public class S3CopyObjectOperation private constructor(builder: Builder) {
    /**
     * This functionality is not supported by directory buckets.
     */
    public val accessControlGrants: List<S3Grant>? = builder.accessControlGrants
    /**
     * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.
     *
     * Specifying this header with an *Copy* action doesn’t affect *bucket-level* settings for S3 Bucket Key.
     *
     * **Directory buckets** - S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through [the Copy operation in Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops). In this case, Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
     */
    public val bucketKeyEnabled: kotlin.Boolean = builder.bucketKeyEnabled
    /**
     * This functionality is not supported by directory buckets.
     */
    public val cannedAccessControlList: aws.sdk.kotlin.services.s3control.model.S3CannedAccessControlList? = builder.cannedAccessControlList
    /**
     * Indicates the algorithm that you want Amazon S3 to use to create the checksum. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3control.model.S3ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     *
     */
    public val metadataDirective: aws.sdk.kotlin.services.s3control.model.S3MetadataDirective? = builder.metadataDirective
    /**
     *
     */
    public val modifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedSinceConstraint
    /**
     * If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
     */
    public val newObjectMetadata: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata? = builder.newObjectMetadata
    /**
     * Specifies a list of tags to add to the destination objects after they are copied. If `NewObjectTagging` is not specified, the tags of the source objects are copied to destination objects by default.
     *
     * **Directory buckets** - Tags aren't supported by directory buckets. If your source objects have tags and your destination bucket is a directory bucket, specify an empty tag set in the `NewObjectTagging` field to prevent copying the source object tags to the directory bucket.
     */
    public val newObjectTagging: List<S3Tag>? = builder.newObjectTagging
    /**
     * The legal hold status to be applied to all objects in the Batch Operations job.
     *
     * This functionality is not supported by directory buckets.
     */
    public val objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3control.model.S3ObjectLockLegalHoldStatus? = builder.objectLockLegalHoldStatus
    /**
     * The retention mode to be applied to all objects in the Batch Operations job.
     *
     * This functionality is not supported by directory buckets.
     */
    public val objectLockMode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockMode? = builder.objectLockMode
    /**
     * The date when the applied object retention configuration expires on all objects in the Batch Operations job.
     *
     * This functionality is not supported by directory buckets.
     */
    public val objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = builder.objectLockRetainUntilDate
    /**
     * If the destination bucket is configured as a website, specifies an optional metadata property for website redirects, `x-amz-website-redirect-location`. Allows webpage redirects if the object copy is accessed through a website endpoint.
     *
     * This functionality is not supported by directory buckets.
     */
    public val redirectLocation: kotlin.String? = builder.redirectLocation
    /**
     * This functionality is not supported by directory buckets.
     */
    public val requesterPays: kotlin.Boolean = builder.requesterPays
    /**
     * Specifies the KMS key ID (Key ID, Key ARN, or Key Alias) to use for object encryption. If the KMS key doesn't exist in the same account that's issuing the command, you must use the full Key ARN not the Key ID.
     *
     * **Directory buckets** - If you specify `SSEAlgorithm` with `KMS`, you must specify the ` SSEAwsKmsKeyId` parameter with the ID (Key ID or Key ARN) of the KMS symmetric encryption customer managed key to use. Otherwise, you get an HTTP `400 Bad Request` error. The key alias format of the KMS key isn't supported. To encrypt new object copies in a directory bucket with SSE-KMS, you must specify SSE-KMS as the directory bucket's default encryption configuration with a KMS key (specifically, a [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)). The [Amazon Web Services managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) (`aws/s3`) isn't supported. Your SSE-KMS configuration can only support 1 [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) per directory bucket for the lifetime of the bucket. After you specify a customer managed key for SSE-KMS as the bucket default encryption, you can't override the customer managed key for the bucket's SSE-KMS configuration. Then, when you specify server-side encryption settings for new object copies with SSE-KMS, you must make sure the encryption key is the same customer managed key that you specified for the directory bucket's default encryption configuration.
     */
    public val sseAwsKmsKeyId: kotlin.String? = builder.sseAwsKmsKeyId
    /**
     * Specify the storage class for the destination objects in a `Copy` operation.
     *
     * **Directory buckets ** - This functionality is not supported by directory buckets.
     */
    public val storageClass: aws.sdk.kotlin.services.s3control.model.S3StorageClass? = builder.storageClass
    /**
     * Specifies the folder prefix that you want the objects to be copied into. For example, to copy objects into a folder named `Folder1` in the destination bucket, set the `TargetKeyPrefix` property to `Folder1`.
     */
    public val targetKeyPrefix: kotlin.String? = builder.targetKeyPrefix
    /**
     * Specifies the destination bucket Amazon Resource Name (ARN) for the batch copy operation.
     * + **General purpose buckets** - For example, to copy objects to a general purpose bucket named `destinationBucket`, set the `TargetResource` property to `arn:aws:s3:::destinationBucket`.
     * + **Directory buckets** - For example, to copy objects to a directory bucket named `destinationBucket` in the Availability Zone identified by the AZ ID `usw2-az1`, set the `TargetResource` property to `arn:aws:s3express:<i>region</i>:<i>account_id</i>:/bucket/<i>destination_bucket_base_name</i>--<i>usw2-az1</i>--x-s3`. A directory bucket as a destination bucket can be in Availability Zone or Local Zone. Copying objects across different Amazon Web Services Regions isn't supported when the source or destination bucket is in Amazon Web Services Local Zones. The source and destination buckets must have the same parent Amazon Web Services Region. Otherwise, you get an HTTP `400 Bad Request` error with the error code `InvalidRequest`.
     */
    public val targetResource: kotlin.String? = builder.targetResource
    /**
     *
     */
    public val unModifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = builder.unModifiedSinceConstraint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3CopyObjectOperation(")
        append("accessControlGrants=$accessControlGrants,")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("cannedAccessControlList=$cannedAccessControlList,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("metadataDirective=$metadataDirective,")
        append("modifiedSinceConstraint=$modifiedSinceConstraint,")
        append("newObjectMetadata=$newObjectMetadata,")
        append("newObjectTagging=$newObjectTagging,")
        append("objectLockLegalHoldStatus=$objectLockLegalHoldStatus,")
        append("objectLockMode=$objectLockMode,")
        append("objectLockRetainUntilDate=$objectLockRetainUntilDate,")
        append("redirectLocation=$redirectLocation,")
        append("requesterPays=$requesterPays,")
        append("sseAwsKmsKeyId=$sseAwsKmsKeyId,")
        append("storageClass=$storageClass,")
        append("targetKeyPrefix=$targetKeyPrefix,")
        append("targetResource=$targetResource,")
        append("unModifiedSinceConstraint=$unModifiedSinceConstraint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlGrants?.hashCode() ?: 0
        result = 31 * result + (bucketKeyEnabled.hashCode())
        result = 31 * result + (cannedAccessControlList?.hashCode() ?: 0)
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (metadataDirective?.hashCode() ?: 0)
        result = 31 * result + (modifiedSinceConstraint?.hashCode() ?: 0)
        result = 31 * result + (newObjectMetadata?.hashCode() ?: 0)
        result = 31 * result + (newObjectTagging?.hashCode() ?: 0)
        result = 31 * result + (objectLockLegalHoldStatus?.hashCode() ?: 0)
        result = 31 * result + (objectLockMode?.hashCode() ?: 0)
        result = 31 * result + (objectLockRetainUntilDate?.hashCode() ?: 0)
        result = 31 * result + (redirectLocation?.hashCode() ?: 0)
        result = 31 * result + (requesterPays.hashCode())
        result = 31 * result + (sseAwsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (targetKeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (targetResource?.hashCode() ?: 0)
        result = 31 * result + (unModifiedSinceConstraint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3CopyObjectOperation

        if (accessControlGrants != other.accessControlGrants) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (cannedAccessControlList != other.cannedAccessControlList) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (metadataDirective != other.metadataDirective) return false
        if (modifiedSinceConstraint != other.modifiedSinceConstraint) return false
        if (newObjectMetadata != other.newObjectMetadata) return false
        if (newObjectTagging != other.newObjectTagging) return false
        if (objectLockLegalHoldStatus != other.objectLockLegalHoldStatus) return false
        if (objectLockMode != other.objectLockMode) return false
        if (objectLockRetainUntilDate != other.objectLockRetainUntilDate) return false
        if (redirectLocation != other.redirectLocation) return false
        if (requesterPays != other.requesterPays) return false
        if (sseAwsKmsKeyId != other.sseAwsKmsKeyId) return false
        if (storageClass != other.storageClass) return false
        if (targetKeyPrefix != other.targetKeyPrefix) return false
        if (targetResource != other.targetResource) return false
        if (unModifiedSinceConstraint != other.unModifiedSinceConstraint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This functionality is not supported by directory buckets.
         */
        public var accessControlGrants: List<S3Grant>? = null
        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.
         *
         * Specifying this header with an *Copy* action doesn’t affect *bucket-level* settings for S3 Bucket Key.
         *
         * **Directory buckets** - S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through [the Copy operation in Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops). In this case, Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
         */
        public var bucketKeyEnabled: kotlin.Boolean = false
        /**
         * This functionality is not supported by directory buckets.
         */
        public var cannedAccessControlList: aws.sdk.kotlin.services.s3control.model.S3CannedAccessControlList? = null
        /**
         * Indicates the algorithm that you want Amazon S3 to use to create the checksum. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3control.model.S3ChecksumAlgorithm? = null
        /**
         *
         */
        public var metadataDirective: aws.sdk.kotlin.services.s3control.model.S3MetadataDirective? = null
        /**
         *
         */
        public var modifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
         */
        public var newObjectMetadata: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata? = null
        /**
         * Specifies a list of tags to add to the destination objects after they are copied. If `NewObjectTagging` is not specified, the tags of the source objects are copied to destination objects by default.
         *
         * **Directory buckets** - Tags aren't supported by directory buckets. If your source objects have tags and your destination bucket is a directory bucket, specify an empty tag set in the `NewObjectTagging` field to prevent copying the source object tags to the directory bucket.
         */
        public var newObjectTagging: List<S3Tag>? = null
        /**
         * The legal hold status to be applied to all objects in the Batch Operations job.
         *
         * This functionality is not supported by directory buckets.
         */
        public var objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3control.model.S3ObjectLockLegalHoldStatus? = null
        /**
         * The retention mode to be applied to all objects in the Batch Operations job.
         *
         * This functionality is not supported by directory buckets.
         */
        public var objectLockMode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockMode? = null
        /**
         * The date when the applied object retention configuration expires on all objects in the Batch Operations job.
         *
         * This functionality is not supported by directory buckets.
         */
        public var objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the destination bucket is configured as a website, specifies an optional metadata property for website redirects, `x-amz-website-redirect-location`. Allows webpage redirects if the object copy is accessed through a website endpoint.
         *
         * This functionality is not supported by directory buckets.
         */
        public var redirectLocation: kotlin.String? = null
        /**
         * This functionality is not supported by directory buckets.
         */
        public var requesterPays: kotlin.Boolean = false
        /**
         * Specifies the KMS key ID (Key ID, Key ARN, or Key Alias) to use for object encryption. If the KMS key doesn't exist in the same account that's issuing the command, you must use the full Key ARN not the Key ID.
         *
         * **Directory buckets** - If you specify `SSEAlgorithm` with `KMS`, you must specify the ` SSEAwsKmsKeyId` parameter with the ID (Key ID or Key ARN) of the KMS symmetric encryption customer managed key to use. Otherwise, you get an HTTP `400 Bad Request` error. The key alias format of the KMS key isn't supported. To encrypt new object copies in a directory bucket with SSE-KMS, you must specify SSE-KMS as the directory bucket's default encryption configuration with a KMS key (specifically, a [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)). The [Amazon Web Services managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) (`aws/s3`) isn't supported. Your SSE-KMS configuration can only support 1 [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) per directory bucket for the lifetime of the bucket. After you specify a customer managed key for SSE-KMS as the bucket default encryption, you can't override the customer managed key for the bucket's SSE-KMS configuration. Then, when you specify server-side encryption settings for new object copies with SSE-KMS, you must make sure the encryption key is the same customer managed key that you specified for the directory bucket's default encryption configuration.
         */
        public var sseAwsKmsKeyId: kotlin.String? = null
        /**
         * Specify the storage class for the destination objects in a `Copy` operation.
         *
         * **Directory buckets ** - This functionality is not supported by directory buckets.
         */
        public var storageClass: aws.sdk.kotlin.services.s3control.model.S3StorageClass? = null
        /**
         * Specifies the folder prefix that you want the objects to be copied into. For example, to copy objects into a folder named `Folder1` in the destination bucket, set the `TargetKeyPrefix` property to `Folder1`.
         */
        public var targetKeyPrefix: kotlin.String? = null
        /**
         * Specifies the destination bucket Amazon Resource Name (ARN) for the batch copy operation.
         * + **General purpose buckets** - For example, to copy objects to a general purpose bucket named `destinationBucket`, set the `TargetResource` property to `arn:aws:s3:::destinationBucket`.
         * + **Directory buckets** - For example, to copy objects to a directory bucket named `destinationBucket` in the Availability Zone identified by the AZ ID `usw2-az1`, set the `TargetResource` property to `arn:aws:s3express:<i>region</i>:<i>account_id</i>:/bucket/<i>destination_bucket_base_name</i>--<i>usw2-az1</i>--x-s3`. A directory bucket as a destination bucket can be in Availability Zone or Local Zone. Copying objects across different Amazon Web Services Regions isn't supported when the source or destination bucket is in Amazon Web Services Local Zones. The source and destination buckets must have the same parent Amazon Web Services Region. Otherwise, you get an HTTP `400 Bad Request` error with the error code `InvalidRequest`.
         */
        public var targetResource: kotlin.String? = null
        /**
         *
         */
        public var unModifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation) : this() {
            this.accessControlGrants = x.accessControlGrants
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.cannedAccessControlList = x.cannedAccessControlList
            this.checksumAlgorithm = x.checksumAlgorithm
            this.metadataDirective = x.metadataDirective
            this.modifiedSinceConstraint = x.modifiedSinceConstraint
            this.newObjectMetadata = x.newObjectMetadata
            this.newObjectTagging = x.newObjectTagging
            this.objectLockLegalHoldStatus = x.objectLockLegalHoldStatus
            this.objectLockMode = x.objectLockMode
            this.objectLockRetainUntilDate = x.objectLockRetainUntilDate
            this.redirectLocation = x.redirectLocation
            this.requesterPays = x.requesterPays
            this.sseAwsKmsKeyId = x.sseAwsKmsKeyId
            this.storageClass = x.storageClass
            this.targetKeyPrefix = x.targetKeyPrefix
            this.targetResource = x.targetResource
            this.unModifiedSinceConstraint = x.unModifiedSinceConstraint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = S3CopyObjectOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata] inside the given [block]
         */
        public fun newObjectMetadata(block: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata.Builder.() -> kotlin.Unit) {
            this.newObjectMetadata = aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
