// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for one or more replication rules. A replication configuration must have at least one rule and you can add up to 100 rules. The maximum size of a replication configuration is 128 KB.
 */
public class ReplicationConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that S3 on Outposts assumes when replicating objects. For information about S3 replication on Outposts configuration, see [Setting up replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-how-setup.html) in the *Amazon S3 User Guide*.
     */
    public val role: kotlin.String = requireNotNull(builder.role) { "A non-null value must be provided for role" }
    /**
     * A container for one or more replication rules. A replication configuration must have at least one rule and can contain an array of 100 rules at the most.
     */
    public val rules: List<ReplicationRule> = requireNotNull(builder.rules) { "A non-null value must be provided for rules" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ReplicationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationConfiguration(")
        append("role=$role,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = role.hashCode()
        result = 31 * result + (rules.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationConfiguration

        if (role != other.role) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ReplicationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that S3 on Outposts assumes when replicating objects. For information about S3 replication on Outposts configuration, see [Setting up replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-how-setup.html) in the *Amazon S3 User Guide*.
         */
        public var role: kotlin.String? = null
        /**
         * A container for one or more replication rules. A replication configuration must have at least one rule and can contain an array of 100 rules at the most.
         */
        public var rules: List<ReplicationRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ReplicationConfiguration) : this() {
            this.role = x.role
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ReplicationConfiguration = ReplicationConfiguration(this)

        internal fun correctErrors(): Builder {
            if (role == null) role = ""
            if (rules == null) rules = emptyList()
            return this
        }
    }
}
