// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetAccessPointResponse private constructor(builder: Builder) {
    /**
     * The ARN of the access point.
     */
    public val accessPointArn: kotlin.String? = builder.accessPointArn
    /**
     * The name or alias of the access point.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The name of the bucket associated with the specified access point.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
     */
    public val bucketAccountId: kotlin.String? = builder.bucketAccountId
    /**
     * The date and time when the specified access point was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The VPC endpoint for the access point.
     */
    public val endpoints: Map<String, String>? = builder.endpoints
    /**
     * The name of the specified access point.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
     *
     * This will always be true for an Amazon S3 on Outposts access point
     */
    public val networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin? = builder.networkOrigin
    /**
     * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
     *
     * This data type is not supported for Amazon S3 on Outposts.
     */
    public val publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = builder.publicAccessBlockConfiguration
    /**
     * Contains the virtual private cloud (VPC) configuration for the specified access point.
     *
     * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services services.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAccessPointResponse(")
        append("accessPointArn=$accessPointArn,")
        append("alias=$alias,")
        append("bucket=$bucket,")
        append("bucketAccountId=$bucketAccountId,")
        append("creationDate=$creationDate,")
        append("endpoints=$endpoints,")
        append("name=$name,")
        append("networkOrigin=$networkOrigin,")
        append("publicAccessBlockConfiguration=$publicAccessBlockConfiguration,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointArn?.hashCode() ?: 0
        result = 31 * result + (alias?.hashCode() ?: 0)
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (bucketAccountId?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkOrigin?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlockConfiguration?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAccessPointResponse

        if (accessPointArn != other.accessPointArn) return false
        if (alias != other.alias) return false
        if (bucket != other.bucket) return false
        if (bucketAccountId != other.bucketAccountId) return false
        if (creationDate != other.creationDate) return false
        if (endpoints != other.endpoints) return false
        if (name != other.name) return false
        if (networkOrigin != other.networkOrigin) return false
        if (publicAccessBlockConfiguration != other.publicAccessBlockConfiguration) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the access point.
         */
        public var accessPointArn: kotlin.String? = null
        /**
         * The name or alias of the access point.
         */
        public var alias: kotlin.String? = null
        /**
         * The name of the bucket associated with the specified access point.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
         */
        public var bucketAccountId: kotlin.String? = null
        /**
         * The date and time when the specified access point was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The VPC endpoint for the access point.
         */
        public var endpoints: Map<String, String>? = null
        /**
         * The name of the specified access point.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
         *
         * This will always be true for an Amazon S3 on Outposts access point
         */
        public var networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin? = null
        /**
         * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
         *
         * This data type is not supported for Amazon S3 on Outposts.
         */
        public var publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration? = null
        /**
         * Contains the virtual private cloud (VPC) configuration for the specified access point.
         *
         * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services services.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse) : this() {
            this.accessPointArn = x.accessPointArn
            this.alias = x.alias
            this.bucket = x.bucket
            this.bucketAccountId = x.bucketAccountId
            this.creationDate = x.creationDate
            this.endpoints = x.endpoints
            this.name = x.name
            this.networkOrigin = x.networkOrigin
            this.publicAccessBlockConfiguration = x.publicAccessBlockConfiguration
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse = GetAccessPointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun publicAccessBlockConfiguration(block: aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlockConfiguration = aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.s3control.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.s3control.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
