// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAccessGrantRequest private constructor(builder: Builder) {
    /**
     * The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. It contains the `S3SubPrefix` field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
     */
    public val accessGrantsLocationConfiguration: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration? = builder.accessGrantsLocationConfiguration
    /**
     * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     *
     * If you are passing the `default` location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the `Subprefix` field.
     */
    public val accessGrantsLocationId: kotlin.String? = builder.accessGrantsLocationId
    /**
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If an application ARN is included in the request to create an access grant, the grantee can only access the S3 data through this application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
     */
    public val grantee: aws.sdk.kotlin.services.s3control.model.Grantee? = builder.grantee
    /**
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:
     * + `READ` – Grant read-only access to the S3 data.
     * + `WRITE` – Grant write-only access to the S3 data.
     * + `READWRITE` – Grant both read and write access to the S3 data.
     */
    public val permission: aws.sdk.kotlin.services.s3control.model.Permission? = builder.permission
    /**
     * The type of `S3SubPrefix`. The only possible value is `Object`. Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix.
     */
    public val s3PrefixType: aws.sdk.kotlin.services.s3control.model.S3PrefixType? = builder.s3PrefixType
    /**
     * The Amazon Web Services resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessGrantRequest(")
        append("accessGrantsLocationConfiguration=$accessGrantsLocationConfiguration,")
        append("accessGrantsLocationId=$accessGrantsLocationId,")
        append("accountId=$accountId,")
        append("applicationArn=$applicationArn,")
        append("grantee=$grantee,")
        append("permission=$permission,")
        append("s3PrefixType=$s3PrefixType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGrantsLocationConfiguration?.hashCode() ?: 0
        result = 31 * result + (accessGrantsLocationId?.hashCode() ?: 0)
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (applicationArn?.hashCode() ?: 0)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (s3PrefixType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessGrantRequest

        if (accessGrantsLocationConfiguration != other.accessGrantsLocationConfiguration) return false
        if (accessGrantsLocationId != other.accessGrantsLocationId) return false
        if (accountId != other.accountId) return false
        if (applicationArn != other.applicationArn) return false
        if (grantee != other.grantee) return false
        if (permission != other.permission) return false
        if (s3PrefixType != other.s3PrefixType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. It contains the `S3SubPrefix` field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
         */
        public var accessGrantsLocationConfiguration: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration? = null
        /**
         * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         *
         * If you are passing the `default` location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the `Subprefix` field.
         */
        public var accessGrantsLocationId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If an application ARN is included in the request to create an access grant, the grantee can only access the S3 data through this application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         */
        public var grantee: aws.sdk.kotlin.services.s3control.model.Grantee? = null
        /**
         * The type of access that you are granting to your S3 data, which can be set to one of the following values:
         * + `READ` – Grant read-only access to the S3 data.
         * + `WRITE` – Grant write-only access to the S3 data.
         * + `READWRITE` – Grant both read and write access to the S3 data.
         */
        public var permission: aws.sdk.kotlin.services.s3control.model.Permission? = null
        /**
         * The type of `S3SubPrefix`. The only possible value is `Object`. Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix.
         */
        public var s3PrefixType: aws.sdk.kotlin.services.s3control.model.S3PrefixType? = null
        /**
         * The Amazon Web Services resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest) : this() {
            this.accessGrantsLocationConfiguration = x.accessGrantsLocationConfiguration
            this.accessGrantsLocationId = x.accessGrantsLocationId
            this.accountId = x.accountId
            this.applicationArn = x.applicationArn
            this.grantee = x.grantee
            this.permission = x.permission
            this.s3PrefixType = x.s3PrefixType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest = CreateAccessGrantRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration] inside the given [block]
         */
        public fun accessGrantsLocationConfiguration(block: aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration.Builder.() -> kotlin.Unit) {
            this.accessGrantsLocationConfiguration = aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.Grantee] inside the given [block]
         */
        public fun grantee(block: aws.sdk.kotlin.services.s3control.model.Grantee.Builder.() -> kotlin.Unit) {
            this.grantee = aws.sdk.kotlin.services.s3control.model.Grantee.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
