/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3control.serde;

import aws.sdk.kotlin.services.s3control.model.ExpirationStatus;
import aws.sdk.kotlin.services.s3control.model.LifecycleRule;
import aws.sdk.kotlin.services.s3control.serde.AbortIncompleteMultipartUploadDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.LifecycleExpirationDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.LifecycleRuleFilterDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.NoncurrentVersionExpirationDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.NoncurrentVersionTransitionListShapeDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.TransitionListShapeDeserializerKt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"deserializeLifecycleRuleDocument", "Laws/sdk/kotlin/services/s3control/model/LifecycleRule;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlTagReader;", "s3control"})
@SourceDebugExtension(value={"SMAP\nLifecycleRuleDocumentDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleRuleDocumentDeserializer.kt\naws/sdk/kotlin/services/s3control/serde/LifecycleRuleDocumentDeserializerKt\n+ 2 Exceptions.kt\naws/smithy/kotlin/runtime/serde/ExceptionsKt\n+ 3 ResultExt.kt\naws/smithy/kotlin/runtime/util/ResultExtKt\n+ 4 Parsers.kt\naws/smithy/kotlin/runtime/serde/ParsersKt\n*L\n1#1,44:1\n45#2:45\n46#2:50\n45#2:52\n46#2:57\n15#3,4:46\n15#3,4:53\n58#4:51\n*S KotlinDebug\n*F\n+ 1 LifecycleRuleDocumentDeserializer.kt\naws/sdk/kotlin/services/s3control/serde/LifecycleRuleDocumentDeserializerKt\n*L\n22#1:45\n22#1:50\n28#1:52\n28#1:57\n22#1:46,4\n28#1:53,4\n27#1:51\n*E\n"})
public final class LifecycleRuleDocumentDeserializerKt {
    @NotNull
    public static final LifecycleRule deserializeLifecycleRuleDocument(@NotNull XmlTagReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        LifecycleRule.Builder builder = new LifecycleRule.Builder();
        while (reader.nextTag() != null) {
            XmlTagReader curr;
            switch (curr.getTagName()) {
                case "Expiration": {
                    builder.setExpiration(LifecycleExpirationDocumentDeserializerKt.deserializeLifecycleExpirationDocument(curr));
                    break;
                }
                case "ID": {
                    LifecycleRule.Builder builder2;
                    boolean bl;
                    Object object;
                    Object $this$getOrDeserializeErr$iv;
                    LifecycleRule.Builder builder3 = builder;
                    Object object2 = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    boolean $i$f$getOrDeserializeErr = false;
                    Object $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder3;
                        boolean bl2 = false;
                        builder3 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (string: `com.amazonaws.s3control#ID`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    $this$mapErr$iv$iv = object;
                    ResultKt.throwOnFailure((Object)$this$mapErr$iv$iv);
                    builder3.setId((String)$this$mapErr$iv$iv);
                    break;
                }
                case "Filter": {
                    builder.setFilter(LifecycleRuleFilterDocumentDeserializerKt.deserializeLifecycleRuleFilterDocument(curr));
                    break;
                }
                case "Status": {
                    Object object;
                    Object object3;
                    Object $this$parse$iv;
                    boolean bl;
                    Object $this$getOrDeserializeErr$iv = XmlTagReaderKt.tryData((XmlTagReader)curr);
                    LifecycleRule.Builder builder2 = builder;
                    boolean $i$f$parse = false;
                    Object $this$mapErr$iv$iv = $this$parse$iv;
                    if (Result.isSuccess-impl((Object)$this$mapErr$iv$iv)) {
                        Object it;
                        Object $i$f$mapErr = $this$mapErr$iv$iv;
                        try {
                            it = (String)$i$f$mapErr;
                            boolean bl3 = false;
                            it = Result.constructor-impl((Object)ExpirationStatus.Companion.fromValue((String)it));
                        }
                        catch (Throwable bl3) {
                            it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                        }
                        object3 = it;
                    } else {
                        object3 = Result.constructor-impl((Object)$this$mapErr$iv$iv);
                    }
                    LifecycleRule.Builder builder4 = builder2;
                    $this$parse$iv = object3;
                    boolean $i$f$getOrDeserializeErr = false;
                    $this$mapErr$iv$iv = $this$getOrDeserializeErr$iv;
                    boolean $i$f$mapErr = false;
                    Throwable ex$iv$iv = Result.exceptionOrNull-impl((Object)$this$mapErr$iv$iv);
                    if (ex$iv$iv == null) {
                        object = $this$mapErr$iv$iv;
                    } else {
                        Throwable it$iv = ex$iv$iv;
                        bl = false;
                        builder2 = builder4;
                        boolean bl4 = false;
                        builder4 = builder2;
                        Throwable throwable = it$iv;
                        String string = "expected (enum: `com.amazonaws.s3control#ExpirationStatus`)";
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new DeserializationException(string, throwable))));
                    }
                    Object object4 = object;
                    ResultKt.throwOnFailure((Object)object4);
                    builder4.setStatus((ExpirationStatus)object4);
                    break;
                }
                case "Transitions": {
                    builder.setTransitions(TransitionListShapeDeserializerKt.deserializeTransitionListShape(curr));
                    break;
                }
                case "NoncurrentVersionTransitions": {
                    builder.setNoncurrentVersionTransitions(NoncurrentVersionTransitionListShapeDeserializerKt.deserializeNoncurrentVersionTransitionListShape(curr));
                    break;
                }
                case "NoncurrentVersionExpiration": {
                    builder.setNoncurrentVersionExpiration(NoncurrentVersionExpirationDocumentDeserializerKt.deserializeNoncurrentVersionExpirationDocument(curr));
                    break;
                }
                case "AbortIncompleteMultipartUpload": {
                    builder.setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadDocumentDeserializerKt.deserializeAbortIncompleteMultipartUploadDocument(curr));
                }
            }
            curr.drop();
        }
        builder.correctErrors$s3control();
        return builder.build();
    }
}

