// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.S3ObjectLockRetentionMode
import aws.sdk.kotlin.services.s3control.model.S3Retention
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeS3RetentionDocument(reader: XmlTagReader): S3Retention {
    val builder = S3Retention.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // RetainUntilDate com.amazonaws.s3control#S3Retention$RetainUntilDate
            "RetainUntilDate" -> builder.retainUntilDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#TimeStamp`)" }
            // Mode com.amazonaws.s3control#S3Retention$Mode
            "Mode" -> builder.mode = curr.tryData()
                .parse { S3ObjectLockRetentionMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#S3ObjectLockRetentionMode`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
