// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.PutBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.Tagging
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutBucketTaggingOperationSerializer: HttpSerializer.NonStreaming<PutBucketTaggingRequest> {
    override fun serialize(context: ExecutionContext, input: PutBucketTaggingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.bucket) { "bucket is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("bucket"))
                add(PercentEncoding.SmithyLabel.encode(input.bucket))
                add(PercentEncoding.Path.encode("tagging"))
            }
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        if (input.tagging != null) {
            val payload = serializeTaggingPayloadWithXmlNameTagging(input.tagging)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
