// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.Credentials
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeCredentialsDocument(reader: XmlTagReader): Credentials {
    val builder = Credentials.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessKeyId com.amazonaws.s3control#Credentials$AccessKeyId
            "AccessKeyId" -> builder.accessKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessKeyId`)" }
            // SecretAccessKey com.amazonaws.s3control#Credentials$SecretAccessKey
            "SecretAccessKey" -> builder.secretAccessKey = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#SecretAccessKey`)" }
            // SessionToken com.amazonaws.s3control#Credentials$SessionToken
            "SessionToken" -> builder.sessionToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#SessionToken`)" }
            // Expiration com.amazonaws.s3control#Credentials$Expiration
            "Expiration" -> builder.expiration = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#Expiration`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
