// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAccessGrantsLocationRequest private constructor(builder: Builder) {
    /**
     * The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     *
     * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
     *
     * If you are passing the `default` location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the `Subprefix` field.
     */
    public val accessGrantsLocationId: kotlin.String? = builder.accessGrantsLocationId
    /**
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccessGrantsLocationRequest(")
        append("accessGrantsLocationId=$accessGrantsLocationId,")
        append("accountId=$accountId,")
        append("iamRoleArn=$iamRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGrantsLocationId?.hashCode() ?: 0
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccessGrantsLocationRequest

        if (accessGrantsLocationId != other.accessGrantsLocationId) return false
        if (accountId != other.accountId) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         *
         * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID `default` to the default location `s3://` and assigns an auto-generated ID to other locations that you register.
         *
         * If you are passing the `default` location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the `Subprefix` field.
         */
        public var accessGrantsLocationId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
         */
        public var iamRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest) : this() {
            this.accessGrantsLocationId = x.accessGrantsLocationId
            this.accountId = x.accountId
            this.iamRoleArn = x.iamRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest = UpdateAccessGrantsLocationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
