// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListCallerAccessGrantsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * If this optional parameter is passed in the request, a filter is applied to the results. The results will include only the access grants for the caller's Identity Center application or for any other applications (`ALL`).
     */
    public val allowedByApplication: kotlin.Boolean? = builder.allowedByApplication
    /**
     * The S3 path of the data that you would like to access. Must start with `s3://`. You can optionally pass only the beginning characters of a path, and S3 Access Grants will search for all applicable grants for the path fragment.
     */
    public val grantScope: kotlin.String? = builder.grantScope
    /**
     * The maximum number of access grants that you would like returned in the `List Caller Access Grants` response. If the results include the pagination token `NextToken`, make another call using the `NextToken` to determine if there are more results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A pagination token to request the next page of results. Pass this value into a subsequent `List Caller Access Grants` request in order to retrieve the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCallerAccessGrantsRequest(")
        append("accountId=$accountId,")
        append("allowedByApplication=$allowedByApplication,")
        append("grantScope=$grantScope,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (allowedByApplication?.hashCode() ?: 0)
        result = 31 * result + (grantScope?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCallerAccessGrantsRequest

        if (accountId != other.accountId) return false
        if (allowedByApplication != other.allowedByApplication) return false
        if (grantScope != other.grantScope) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * If this optional parameter is passed in the request, a filter is applied to the results. The results will include only the access grants for the caller's Identity Center application or for any other applications (`ALL`).
         */
        public var allowedByApplication: kotlin.Boolean? = null
        /**
         * The S3 path of the data that you would like to access. Must start with `s3://`. You can optionally pass only the beginning characters of a path, and S3 Access Grants will search for all applicable grants for the path fragment.
         */
        public var grantScope: kotlin.String? = null
        /**
         * The maximum number of access grants that you would like returned in the `List Caller Access Grants` response. If the results include the pagination token `NextToken`, make another call using the `NextToken` to determine if there are more results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A pagination token to request the next page of results. Pass this value into a subsequent `List Caller Access Grants` request in order to retrieve the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsRequest) : this() {
            this.accountId = x.accountId
            this.allowedByApplication = x.allowedByApplication
            this.grantScope = x.grantScope
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsRequest = ListCallerAccessGrantsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
