// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Part of `ListCallerAccessGrantsResult`. Each entry includes the permission level (READ, WRITE, or READWRITE) and the grant scope of the access grant. If the grant also includes an application ARN, the grantee can only access the S3 data through this application.
 */
public class ListCallerAccessGrantsEntry private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The S3 path of the data to which you have been granted access.
     */
    public val grantScope: kotlin.String? = builder.grantScope
    /**
     * The type of permission granted, which can be one of the following values:
     * + `READ` - Grants read-only access to the S3 data.
     * + `WRITE` - Grants write-only access to the S3 data.
     * + `READWRITE` - Grants both read and write access to the S3 data.
     */
    public val permission: aws.sdk.kotlin.services.s3control.model.Permission? = builder.permission

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCallerAccessGrantsEntry(")
        append("applicationArn=$applicationArn,")
        append("grantScope=$grantScope,")
        append("permission=$permission")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (grantScope?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCallerAccessGrantsEntry

        if (applicationArn != other.applicationArn) return false
        if (grantScope != other.grantScope) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The S3 path of the data to which you have been granted access.
         */
        public var grantScope: kotlin.String? = null
        /**
         * The type of permission granted, which can be one of the following values:
         * + `READ` - Grants read-only access to the S3 data.
         * + `WRITE` - Grants write-only access to the S3 data.
         * + `READWRITE` - Grants both read and write access to the S3 data.
         */
        public var permission: aws.sdk.kotlin.services.s3control.model.Permission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsEntry) : this() {
            this.applicationArn = x.applicationArn
            this.grantScope = x.grantScope
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsEntry = ListCallerAccessGrantsEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
