// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.endpoints

import aws.sdk.kotlin.runtime.endpoint.functions.parseArn
import aws.sdk.kotlin.services.s3control.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.AccountIdBasedEndpointAccountId
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.client.endpoints.functions.isValidHostLabel
import aws.smithy.kotlin.runtime.client.endpoints.functions.parseUrl
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.Headers
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultS3ControlEndpointProvider: S3ControlEndpointProvider {
    public override suspend fun resolveEndpoint(params: S3ControlEndpointParameters): Endpoint {
        if (
            params.region != null
        ) {
            run {
                val url = parseUrl(params.endpoint)
                if (
                    url != null &&
                    params.region == "snow" &&
                    params.endpoint != null
                ) {
                    run {
                        val partitionResult = partition(params.region)
                        if (
                            partitionResult != null
                        ) {
                            if (
                                params.useDualStack == true
                            ) {
                                throw EndpointProviderException("S3 Snow does not support DualStack")
                            }
                            if (
                                params.useFips == true
                            ) {
                                throw EndpointProviderException("S3 Snow does not support FIPS")
                            }
                            return Endpoint(
                                Url.parse("${url?.scheme}://${url?.authority}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                    }
                }
            }
            if (
                params.outpostId != null
            ) {
                run {
                    val partitionResult = partition(params.region)
                    if (
                        partitionResult != null
                    ) {
                        if (
                            params.useFips == true &&
                            partitionResult?.name == "aws-cn"
                        ) {
                            throw EndpointProviderException("Partition does not support FIPS")
                        }
                        if (
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            !(params.accountId != null)
                        ) {
                            throw EndpointProviderException("AccountId is required but not set")
                        }
                        if (
                            params.accountId != null &&
                            !(isValidHostLabel(params.accountId, false))
                        ) {
                            throw EndpointProviderException("AccountId must only contain a-z, A-Z, 0-9 and `-`.")
                        }
                        if (
                            !(isValidHostLabel(params.outpostId, false))
                        ) {
                            throw EndpointProviderException("OutpostId must only contain a-z, A-Z, 0-9 and `-`.")
                        }
                        if (
                            params.endpoint != null &&
                            params.useDualStack == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: DualStack and custom endpoint are not supported")
                        }
                        if (
                            isValidHostLabel(params.region, true)
                        ) {
                            run {
                                val url = parseUrl(params.endpoint)
                                if (
                                    url != null &&
                                    params.endpoint != null
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3-outposts",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-outposts-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3-outposts",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-outposts-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3-outposts",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useDualStack == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-outposts.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3-outposts",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            return Endpoint(
                                Url.parse("https://s3-outposts.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3-outposts",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                    }
                }
            }
            run {
                val accessPointArn = parseArn(params.accessPointName)
                if (
                    accessPointArn != null &&
                    params.accessPointName != null
                ) {
                    run {
                        val arnType = accessPointArn?.resourceId?.getOrNull(0)
                        if (
                            arnType != null &&
                            !(arnType == "")
                        ) {
                            if (
                                accessPointArn?.service == "s3-outposts"
                            ) {
                                run {
                                    val outpostId = accessPointArn?.resourceId?.getOrNull(1)
                                    if (
                                        outpostId != null
                                    ) {
                                        if (
                                            isValidHostLabel(outpostId, false)
                                        ) {
                                            if (
                                                params.endpoint != null &&
                                                params.useDualStack == true
                                            ) {
                                                throw EndpointProviderException("Invalid Configuration: DualStack and custom endpoint are not supported")
                                            }
                                            if (
                                                params.useArnRegion != null &&
                                                params.useArnRegion == false &&
                                                !(accessPointArn?.region == "${params.region}")
                                            ) {
                                                throw EndpointProviderException("Invalid configuration: region from ARN `${accessPointArn?.region}` does not match client region `${params.region}` and UseArnRegion is `false`")
                                            }
                                            run {
                                                val partitionResult = partition(params.region)
                                                if (
                                                    partitionResult != null
                                                ) {
                                                    run {
                                                        val arnPartition = partition(accessPointArn?.region)
                                                        if (
                                                            arnPartition != null
                                                        ) {
                                                            if (
                                                                arnPartition?.name == partitionResult?.name
                                                            ) {
                                                                if (
                                                                    isValidHostLabel(accessPointArn?.region, true)
                                                                ) {
                                                                    if (
                                                                        !(accessPointArn?.accountId == "")
                                                                    ) {
                                                                        if (
                                                                            isValidHostLabel(accessPointArn?.accountId, false)
                                                                        ) {
                                                                            if (
                                                                                params.accountId != null &&
                                                                                !(params.accountId == "${accessPointArn?.accountId}")
                                                                            ) {
                                                                                throw EndpointProviderException("Invalid ARN: the accountId specified in the ARN (`${accessPointArn?.accountId}`) does not match the parameter (`${params.accountId}`)")
                                                                            }
                                                                            run {
                                                                                val outpostType = accessPointArn?.resourceId?.getOrNull(2)
                                                                                if (
                                                                                    outpostType != null
                                                                                ) {
                                                                                    run {
                                                                                        val accessPointName = accessPointArn?.resourceId?.getOrNull(3)
                                                                                        if (
                                                                                            accessPointName != null
                                                                                        ) {
                                                                                            if (
                                                                                                outpostType == "accesspoint"
                                                                                            ) {
                                                                                                if (
                                                                                                    params.useFips == true &&
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts-fips.${accessPointArn?.region}.${arnPartition?.dualStackDnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${accessPointArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${accessPointArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts-fips.${accessPointArn?.region}.${arnPartition?.dnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${accessPointArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${accessPointArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts.${accessPointArn?.region}.${arnPartition?.dualStackDnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${accessPointArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${accessPointArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                run {
                                                                                                    val url = parseUrl(params.endpoint)
                                                                                                    if (
                                                                                                        url != null &&
                                                                                                        params.endpoint != null
                                                                                                    ) {
                                                                                                        return Endpoint(
                                                                                                            Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                                                                                            headers = Headers {
                                                                                                                append("x-amz-account-id", "${accessPointArn?.accountId}")
                                                                                                                append("x-amz-outpost-id", "${outpostId}")
                                                                                                            },
                                                                                                            attributes = attributesOf {
                                                                                                                SigningContextAttributeKey to listOf(
                                                                                                                    sigV4(
                                                                                                                        serviceName = "s3-outposts",
                                                                                                                        disableDoubleUriEncode = true,
                                                                                                                        signingRegion = "${accessPointArn?.region}",
                                                                                                                    ),
                                                                                                                )
                                                                                                            },
                                                                                                        )
                                                                                                    }
                                                                                                }
                                                                                                return Endpoint(
                                                                                                    Url.parse("https://s3-outposts.${accessPointArn?.region}.${arnPartition?.dnsSuffix}"),
                                                                                                    headers = Headers {
                                                                                                        append("x-amz-account-id", "${accessPointArn?.accountId}")
                                                                                                        append("x-amz-outpost-id", "${outpostId}")
                                                                                                    },
                                                                                                    attributes = attributesOf {
                                                                                                        SigningContextAttributeKey to listOf(
                                                                                                            sigV4(
                                                                                                                serviceName = "s3-outposts",
                                                                                                                disableDoubleUriEncode = true,
                                                                                                                signingRegion = "${accessPointArn?.region}",
                                                                                                            ),
                                                                                                        )
                                                                                                    },
                                                                                                )
                                                                                            }
                                                                                            throw EndpointProviderException("Expected an outpost type `accesspoint`, found `${outpostType}`")
                                                                                        }
                                                                                    }
                                                                                    throw EndpointProviderException("Invalid ARN: expected an access point name")
                                                                                }
                                                                            }
                                                                            throw EndpointProviderException("Invalid ARN: Expected a 4-component resource")
                                                                        }
                                                                        throw EndpointProviderException("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `${accessPointArn?.accountId}`")
                                                                    }
                                                                    throw EndpointProviderException("Invalid ARN: missing account ID")
                                                                }
                                                                throw EndpointProviderException("Invalid region in ARN: `${accessPointArn?.region}` (invalid DNS name)")
                                                            }
                                                            throw EndpointProviderException("Client was configured for partition `${partitionResult?.name}` but ARN has `${arnPartition?.name}`")
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        throw EndpointProviderException("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `${outpostId}`")
                                    }
                                }
                                throw EndpointProviderException("Invalid ARN: The Outpost Id was not set")
                            }
                        }
                    }
                    throw EndpointProviderException("Invalid ARN: No ARN type specified")
                }
            }
            run {
                val bucketArn = parseArn(params.bucket)
                if (
                    bucketArn != null &&
                    params.bucket != null
                ) {
                    run {
                        val arnType = bucketArn?.resourceId?.getOrNull(0)
                        if (
                            arnType != null &&
                            !(arnType == "")
                        ) {
                            if (
                                bucketArn?.service == "s3-outposts"
                            ) {
                                run {
                                    val outpostId = bucketArn?.resourceId?.getOrNull(1)
                                    if (
                                        outpostId != null
                                    ) {
                                        if (
                                            isValidHostLabel(outpostId, false)
                                        ) {
                                            if (
                                                params.endpoint != null &&
                                                params.useDualStack == true
                                            ) {
                                                throw EndpointProviderException("Invalid Configuration: DualStack and custom endpoint are not supported")
                                            }
                                            if (
                                                params.useArnRegion != null &&
                                                params.useArnRegion == false &&
                                                !(bucketArn?.region == "${params.region}")
                                            ) {
                                                throw EndpointProviderException("Invalid configuration: region from ARN `${bucketArn?.region}` does not match client region `${params.region}` and UseArnRegion is `false`")
                                            }
                                            run {
                                                val arnPartition = partition(bucketArn?.region)
                                                if (
                                                    arnPartition != null
                                                ) {
                                                    run {
                                                        val partitionResult = partition(params.region)
                                                        if (
                                                            partitionResult != null
                                                        ) {
                                                            if (
                                                                arnPartition?.name == partitionResult?.name
                                                            ) {
                                                                if (
                                                                    isValidHostLabel(bucketArn?.region, true)
                                                                ) {
                                                                    if (
                                                                        !(bucketArn?.accountId == "")
                                                                    ) {
                                                                        if (
                                                                            isValidHostLabel(bucketArn?.accountId, false)
                                                                        ) {
                                                                            if (
                                                                                params.accountId != null &&
                                                                                !(params.accountId == "${bucketArn?.accountId}")
                                                                            ) {
                                                                                throw EndpointProviderException("Invalid ARN: the accountId specified in the ARN (`${bucketArn?.accountId}`) does not match the parameter (`${params.accountId}`)")
                                                                            }
                                                                            run {
                                                                                val outpostType = bucketArn?.resourceId?.getOrNull(2)
                                                                                if (
                                                                                    outpostType != null
                                                                                ) {
                                                                                    run {
                                                                                        val bucketName = bucketArn?.resourceId?.getOrNull(3)
                                                                                        if (
                                                                                            bucketName != null
                                                                                        ) {
                                                                                            if (
                                                                                                outpostType == "bucket"
                                                                                            ) {
                                                                                                if (
                                                                                                    params.useFips == true &&
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts-fips.${bucketArn?.region}.${arnPartition?.dualStackDnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${bucketArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts-fips.${bucketArn?.region}.${arnPartition?.dnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${bucketArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://s3-outposts.${bucketArn?.region}.${arnPartition?.dualStackDnsSuffix}"),
                                                                                                        headers = Headers {
                                                                                                            append("x-amz-account-id", "${bucketArn?.accountId}")
                                                                                                            append("x-amz-outpost-id", "${outpostId}")
                                                                                                        },
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3-outposts",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                run {
                                                                                                    val url = parseUrl(params.endpoint)
                                                                                                    if (
                                                                                                        url != null &&
                                                                                                        params.endpoint != null
                                                                                                    ) {
                                                                                                        return Endpoint(
                                                                                                            Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                                                                                            headers = Headers {
                                                                                                                append("x-amz-account-id", "${bucketArn?.accountId}")
                                                                                                                append("x-amz-outpost-id", "${outpostId}")
                                                                                                            },
                                                                                                            attributes = attributesOf {
                                                                                                                SigningContextAttributeKey to listOf(
                                                                                                                    sigV4(
                                                                                                                        serviceName = "s3-outposts",
                                                                                                                        disableDoubleUriEncode = true,
                                                                                                                        signingRegion = "${bucketArn?.region}",
                                                                                                                    ),
                                                                                                                )
                                                                                                            },
                                                                                                        )
                                                                                                    }
                                                                                                }
                                                                                                return Endpoint(
                                                                                                    Url.parse("https://s3-outposts.${bucketArn?.region}.${arnPartition?.dnsSuffix}"),
                                                                                                    headers = Headers {
                                                                                                        append("x-amz-account-id", "${bucketArn?.accountId}")
                                                                                                        append("x-amz-outpost-id", "${outpostId}")
                                                                                                    },
                                                                                                    attributes = attributesOf {
                                                                                                        SigningContextAttributeKey to listOf(
                                                                                                            sigV4(
                                                                                                                serviceName = "s3-outposts",
                                                                                                                disableDoubleUriEncode = true,
                                                                                                                signingRegion = "${bucketArn?.region}",
                                                                                                            ),
                                                                                                        )
                                                                                                    },
                                                                                                )
                                                                                            }
                                                                                            throw EndpointProviderException("Invalid ARN: Expected an outpost type `bucket`, found `${outpostType}`")
                                                                                        }
                                                                                    }
                                                                                    throw EndpointProviderException("Invalid ARN: expected a bucket name")
                                                                                }
                                                                            }
                                                                            throw EndpointProviderException("Invalid ARN: Expected a 4-component resource")
                                                                        }
                                                                        throw EndpointProviderException("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `${bucketArn?.accountId}`")
                                                                    }
                                                                    throw EndpointProviderException("Invalid ARN: missing account ID")
                                                                }
                                                                throw EndpointProviderException("Invalid region in ARN: `${bucketArn?.region}` (invalid DNS name)")
                                                            }
                                                            throw EndpointProviderException("Client was configured for partition `${partitionResult?.name}` but ARN has `${arnPartition?.name}`")
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        throw EndpointProviderException("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `${outpostId}`")
                                    }
                                }
                                throw EndpointProviderException("Invalid ARN: The Outpost Id was not set")
                            }
                        }
                    }
                    throw EndpointProviderException("Invalid ARN: No ARN type specified")
                }
            }
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        isValidHostLabel(params.region, true)
                    ) {
                        if (
                            params.useFips == true &&
                            partitionResult?.name == "aws-cn"
                        ) {
                            throw EndpointProviderException("Partition does not support FIPS")
                        }
                        if (
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            !(params.accountId != null)
                        ) {
                            throw EndpointProviderException("AccountId is required but not set")
                        }
                        if (
                            params.accountId != null &&
                            !(isValidHostLabel(params.accountId, false))
                        ) {
                            throw EndpointProviderException("AccountId must only contain a-z, A-Z, 0-9 and `-`.")
                        }
                        run {
                            val url = parseUrl(params.endpoint)
                            if (
                                url != null &&
                                params.endpoint != null
                            ) {
                                if (
                                    params.useDualStack == true
                                ) {
                                    throw EndpointProviderException("Invalid Configuration: DualStack and custom endpoint are not supported")
                                }
                                if (
                                    params.requiresAccountId != null &&
                                    params.requiresAccountId == true &&
                                    params.accountId != null
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${params.accountId}.${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                            AccountIdBasedEndpointAccountId to params.accountId
                                        },
                                    )
                                }
                                return Endpoint(
                                    Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                        }
                        if (
                            params.useFips == true &&
                            params.useDualStack == true &&
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            params.accountId != null
                        ) {
                            return Endpoint(
                                Url.parse("https://${params.accountId}.s3-control-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                    AccountIdBasedEndpointAccountId to params.accountId
                                },
                            )
                        }
                        if (
                            params.useFips == true &&
                            params.useDualStack == true
                        ) {
                            return Endpoint(
                                Url.parse("https://s3-control-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.useFips == true &&
                            params.useDualStack == false &&
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            params.accountId != null
                        ) {
                            return Endpoint(
                                Url.parse("https://${params.accountId}.s3-control-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                    AccountIdBasedEndpointAccountId to params.accountId
                                },
                            )
                        }
                        if (
                            params.useFips == true &&
                            params.useDualStack == false
                        ) {
                            return Endpoint(
                                Url.parse("https://s3-control-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.useFips == false &&
                            params.useDualStack == true &&
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            params.accountId != null
                        ) {
                            return Endpoint(
                                Url.parse("https://${params.accountId}.s3-control.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                    AccountIdBasedEndpointAccountId to params.accountId
                                },
                            )
                        }
                        if (
                            params.useFips == false &&
                            params.useDualStack == true
                        ) {
                            return Endpoint(
                                Url.parse("https://s3-control.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.useFips == false &&
                            params.useDualStack == false &&
                            params.requiresAccountId != null &&
                            params.requiresAccountId == true &&
                            params.accountId != null
                        ) {
                            return Endpoint(
                                Url.parse("https://${params.accountId}.s3-control.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                    AccountIdBasedEndpointAccountId to params.accountId
                                },
                            )
                        }
                        if (
                            params.useFips == false &&
                            params.useDualStack == false
                        ) {
                            return Endpoint(
                                Url.parse("https://s3-control.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                    }
                    throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                }
            }
        }
        throw EndpointProviderException("Region must be set")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
