// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.s3control.auth.DefaultS3ControlAuthSchemeProvider
import aws.sdk.kotlin.services.s3control.auth.S3ControlAuthSchemeProvider
import aws.sdk.kotlin.services.s3control.endpoints.DefaultS3ControlEndpointProvider
import aws.sdk.kotlin.services.s3control.endpoints.S3ControlEndpointParameters
import aws.sdk.kotlin.services.s3control.endpoints.S3ControlEndpointProvider
import aws.sdk.kotlin.services.s3control.model.AssociateAccessGrantsIdentityCenterRequest
import aws.sdk.kotlin.services.s3control.model.AssociateAccessGrantsIdentityCenterResponse
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantResponse
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsInstanceResponse
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationResponse
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.CreateAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.CreateBucketRequest
import aws.sdk.kotlin.services.s3control.model.CreateBucketResponse
import aws.sdk.kotlin.services.s3control.model.CreateJobRequest
import aws.sdk.kotlin.services.s3control.model.CreateJobResponse
import aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.CreateMultiRegionAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.CreateStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.CreateStorageLensGroupResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsInstanceResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessGrantsLocationResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointPolicyResponse
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeleteAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketLifecycleConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.DeleteBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketPolicyResponse
import aws.sdk.kotlin.services.s3control.model.DeleteBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketReplicationResponse
import aws.sdk.kotlin.services.s3control.model.DeleteBucketRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketResponse
import aws.sdk.kotlin.services.s3control.model.DeleteBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteBucketTaggingResponse
import aws.sdk.kotlin.services.s3control.model.DeleteJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteJobTaggingResponse
import aws.sdk.kotlin.services.s3control.model.DeleteMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.DeleteMultiRegionAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.DeletePublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.DeletePublicAccessBlockResponse
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensConfigurationTaggingResponse
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.DeleteStorageLensGroupResponse
import aws.sdk.kotlin.services.s3control.model.DescribeJobRequest
import aws.sdk.kotlin.services.s3control.model.DescribeJobResponse
import aws.sdk.kotlin.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
import aws.sdk.kotlin.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse
import aws.sdk.kotlin.services.s3control.model.DissociateAccessGrantsIdentityCenterRequest
import aws.sdk.kotlin.services.s3control.model.DissociateAccessGrantsIdentityCenterResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceForPrefixRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceForPrefixResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceResourcePolicyResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsLocationResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointPolicyStatusResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketLifecycleConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketPolicyResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketReplicationResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketTaggingResponse
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.GetBucketVersioningResponse
import aws.sdk.kotlin.services.s3control.model.GetDataAccessRequest
import aws.sdk.kotlin.services.s3control.model.GetDataAccessResponse
import aws.sdk.kotlin.services.s3control.model.GetJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetJobTaggingResponse
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyResponse
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.GetMultiRegionAccessPointRoutesResponse
import aws.sdk.kotlin.services.s3control.model.GetPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.GetPublicAccessBlockResponse
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensConfigurationTaggingResponse
import aws.sdk.kotlin.services.s3control.model.GetStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.GetStorageLensGroupResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsInstancesResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsLocationsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsLocationsResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessGrantsResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsRequest
import aws.sdk.kotlin.services.s3control.model.ListCallerAccessGrantsResponse
import aws.sdk.kotlin.services.s3control.model.ListJobsRequest
import aws.sdk.kotlin.services.s3control.model.ListJobsResponse
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsRequest
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsResponse
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsResponse
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensGroupsResponse
import aws.sdk.kotlin.services.s3control.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.s3control.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.s3control.model.PutAccessGrantsInstanceResourcePolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessGrantsInstanceResourcePolicyResponse
import aws.sdk.kotlin.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutAccessPointPolicyResponse
import aws.sdk.kotlin.services.s3control.model.PutBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketLifecycleConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.PutBucketPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketPolicyResponse
import aws.sdk.kotlin.services.s3control.model.PutBucketReplicationRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketReplicationResponse
import aws.sdk.kotlin.services.s3control.model.PutBucketTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketTaggingResponse
import aws.sdk.kotlin.services.s3control.model.PutBucketVersioningRequest
import aws.sdk.kotlin.services.s3control.model.PutBucketVersioningResponse
import aws.sdk.kotlin.services.s3control.model.PutJobTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutJobTaggingResponse
import aws.sdk.kotlin.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
import aws.sdk.kotlin.services.s3control.model.PutMultiRegionAccessPointPolicyResponse
import aws.sdk.kotlin.services.s3control.model.PutPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3control.model.PutPublicAccessBlockResponse
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationResponse
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationTaggingRequest
import aws.sdk.kotlin.services.s3control.model.PutStorageLensConfigurationTaggingResponse
import aws.sdk.kotlin.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
import aws.sdk.kotlin.services.s3control.model.SubmitMultiRegionAccessPointRoutesResponse
import aws.sdk.kotlin.services.s3control.model.TagResourceRequest
import aws.sdk.kotlin.services.s3control.model.TagResourceResponse
import aws.sdk.kotlin.services.s3control.model.UntagResourceRequest
import aws.sdk.kotlin.services.s3control.model.UntagResourceResponse
import aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest
import aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationResponse
import aws.sdk.kotlin.services.s3control.model.UpdateJobPriorityRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobPriorityResponse
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusRequest
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusResponse
import aws.sdk.kotlin.services.s3control.model.UpdateStorageLensGroupRequest
import aws.sdk.kotlin.services.s3control.model.UpdateStorageLensGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "S3 Control"
public const val SdkVersion: String = "1.3.35"
public const val ServiceApiVersion: String = "2018-08-20"

/**
 * Amazon Web Services S3 Control provides access to Amazon S3 control plane actions.
 */
public interface S3ControlClient : SdkClient {
    /**
     * S3ControlClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, S3ControlClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "S3Control",
                "S3_CONTROL",
                "s3_control",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, S3ControlClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): S3ControlClient = DefaultS3ControlClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val enableAwsChunked: Boolean = builder.enableAwsChunked ?: true
        public val endpointProvider: S3ControlEndpointProvider = builder.endpointProvider ?: DefaultS3ControlEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        public val useArnRegion: Boolean = builder.useArnRegion
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: S3ControlAuthSchemeProvider = builder.authSchemeProvider ?: DefaultS3ControlAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            enableAwsChunked = this@Config.enableAwsChunked
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useArnRegion = this@Config.useArnRegion
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "S3 Control"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * Flag to enable [aws-chunked](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-streaming.html) content encoding.
             */
            public var enableAwsChunked: Boolean? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: S3ControlEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             * Flag to enforce using a bucket arn with a region matching the client config when making requests with
             * [S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html).
             */
            public var useArnRegion: Boolean = false

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: S3ControlAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance. Use this action if you want to create access grants for users or groups from your corporate identity directory. First, you must add your corporate identity directory to Amazon Web Services IAM Identity Center. Then, you can associate this IAM Identity Center instance with your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:AssociateAccessGrantsIdentityCenter` permission to use this operation.
     *
     * ## Additional Permissions
     * You must also have the following permissions: `sso:CreateApplication`, `sso:PutApplicationGrant`, and `sso:PutApplicationAuthenticationMethod`.
     */
    public suspend fun associateAccessGrantsIdentityCenter(input: AssociateAccessGrantsIdentityCenterRequest): AssociateAccessGrantsIdentityCenterResponse

    /**
     * Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the [CreateAccessGrantsInstance](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html). You must also have registered at least one S3 data location in your S3 Access Grants instance using [CreateAccessGrantsLocation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html).
     *
     * ## Permissions
     * You must have the `s3:CreateAccessGrant` permission to use this operation.
     *
     * ## Additional Permissions
     * For any directory identity - `sso:DescribeInstance` and `sso:DescribeApplication`
     *
     * For directory users - `identitystore:DescribeUser`
     *
     * For directory groups - `identitystore:DescribeGroup`
     */
    public suspend fun createAccessGrant(input: CreateAccessGrantRequest): CreateAccessGrantResponse

    /**
     * Creates an S3 Access Grants instance, which serves as a logical grouping for access grants. You can create one S3 Access Grants instance per Region per account.
     *
     * ## Permissions
     * You must have the `s3:CreateAccessGrantsInstance` permission to use this operation.
     *
     * ## Additional Permissions
     * To associate an IAM Identity Center instance with your S3 Access Grants instance, you must also have the `sso:DescribeInstance`, `sso:CreateApplication`, `sso:PutApplicationGrant`, and `sso:PutApplicationAuthenticationMethod` permissions.
     */
    public suspend fun createAccessGrantsInstance(input: CreateAccessGrantsInstanceRequest): CreateAccessGrantsInstanceResponse

    /**
     * The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in the same Region as your S3 Access Grants instance. The location can be one of the following:
     * + The default S3 location `s3://`
     * + A bucket - `S3://<bucket-name>`
     * + A bucket and prefix - `S3://<bucket-name>/<prefix>`
     *
     * When you register a location, you must include the IAM role that has permission to manage the S3 location that you are registering. Give S3 Access Grants permission to assume this role [using a policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-location.html). S3 Access Grants assumes this role to manage access to the location and to vend temporary credentials to grantees or client applications.
     *
     * ## Permissions
     * You must have the `s3:CreateAccessGrantsLocation` permission to use this operation.
     *
     * ## Additional Permissions
     * You must also have the following permission for the specified IAM role: `iam:PassRole`
     */
    public suspend fun createAccessGrantsLocation(input: CreateAccessGrantsLocationRequest): CreateAccessGrantsLocationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Creates an access point and associates it with the specified bucket. For more information, see [Managing Data Access with Amazon S3 Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
     *
     * S3 on Outposts only supports VPC-style access points.
     *
     * For more information, see [ Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples) section.
     *
     * The following actions are related to `CreateAccessPoint`:
     * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
     * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
     * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
     */
    public suspend fun createAccessPoint(input: CreateAccessPointRequest): CreateAccessPointResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Creates an Object Lambda Access Point. For more information, see [Transforming objects with Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `CreateAccessPointForObjectLambda`:
     * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
     * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
     * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
     */
    public suspend fun createAccessPointForObjectLambda(input: CreateAccessPointForObjectLambdaRequest): CreateAccessPointForObjectLambdaResponse

    /**
     * This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see [Create Bucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) in the *Amazon S3 API Reference*.
     *
     * Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
     *
     * Not every string is an acceptable bucket name. For information on bucket naming restrictions, see [Working with Amazon S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules).
     *
     * S3 on Outposts buckets support:
     * + Tags
     * + LifecycleConfigurations for deleting expired objects
     *
     * For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see [ Amazon S3 on Outposts Restrictions and Limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html).
     *
     * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and `x-amz-outpost-id` in your API request, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples) section.
     *
     * The following actions are related to `CreateBucket` for Amazon S3 on Outposts:
     * + [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
     * + [GetBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
     * + [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
     * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
     * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
     */
    public suspend fun createBucket(input: CreateBucketRequest): CreateBucketResponse

    /**
     * This operation creates an S3 Batch Operations job.
     *
     * You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
     *
     * ## Permissions
     * For information about permissions required to use the Batch Operations, see [Granting permissions for S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-iam-role-policies.html) in the *Amazon S3 User Guide*.
     *
     * Related actions include:
     * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
     * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
     * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
     * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
     * + [JobOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html)
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see [Creating Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html) in the *Amazon S3 User Guide*.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with `DescribeMultiRegionAccessPointOperation`.
     *
     * The following actions are related to `CreateMultiRegionAccessPoint`:
     * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
     * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
     * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
     * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
     */
    public suspend fun createMultiRegionAccessPoint(input: CreateMultiRegionAccessPointRequest): CreateMultiRegionAccessPointResponse

    /**
     * Creates a new S3 Storage Lens group and associates it with the specified Amazon Web Services account ID. An S3 Storage Lens group is a custom grouping of objects based on prefix, suffix, object tags, object size, object age, or a combination of these filters. For each Storage Lens group that you’ve created, you can also optionally add Amazon Web Services resource tags. For more information about S3 Storage Lens groups, see [Working with S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html).
     *
     * To use this operation, you must have the permission to perform the `s3:CreateStorageLensGroup` action. If you’re trying to create a Storage Lens group with Amazon Web Services resource tags, you must also have permission to perform the `s3:TagResource` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
     */
    public suspend fun createStorageLensGroup(input: CreateStorageLensGroupRequest): CreateStorageLensGroupResponse

    /**
     * Deletes the access grant from the S3 Access Grants instance. You cannot undo an access grant deletion and the grantee will no longer have access to the S3 data.
     *
     * ## Permissions
     * You must have the `s3:DeleteAccessGrant` permission to use this operation.
     */
    public suspend fun deleteAccessGrant(input: DeleteAccessGrantRequest): DeleteAccessGrantResponse

    /**
     * Deletes your S3 Access Grants instance. You must first delete the access grants and locations before S3 Access Grants can delete the instance. See [DeleteAccessGrant](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html) and [DeleteAccessGrantsLocation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrantsLocation.html). If you have associated an IAM Identity Center instance with your S3 Access Grants instance, you must first dissassociate the Identity Center instance from the S3 Access Grants instance before you can delete the S3 Access Grants instance. See [AssociateAccessGrantsIdentityCenter](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AssociateAccessGrantsIdentityCenter.html) and [DissociateAccessGrantsIdentityCenter](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DissociateAccessGrantsIdentityCenter.html).
     *
     * ## Permissions
     * You must have the `s3:DeleteAccessGrantsInstance` permission to use this operation.
     */
    public suspend fun deleteAccessGrantsInstance(input: DeleteAccessGrantsInstanceRequest): DeleteAccessGrantsInstanceResponse

    /**
     * Deletes the resource policy of the S3 Access Grants instance. The resource policy is used to manage cross-account access to your S3 Access Grants instance. By deleting the resource policy, you delete any cross-account permissions to your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:DeleteAccessGrantsInstanceResourcePolicy` permission to use this operation.
     */
    public suspend fun deleteAccessGrantsInstanceResourcePolicy(input: DeleteAccessGrantsInstanceResourcePolicyRequest): DeleteAccessGrantsInstanceResourcePolicyResponse

    /**
     * Deregisters a location from your S3 Access Grants instance. You can only delete a location registration from an S3 Access Grants instance if there are no grants associated with this location. See [Delete a grant](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html) for information on how to delete grants. You need to have at least one registered location in your S3 Access Grants instance in order to create access grants.
     *
     * ## Permissions
     * You must have the `s3:DeleteAccessGrantsLocation` permission to use this operation.
     */
    public suspend fun deleteAccessGrantsLocation(input: DeleteAccessGrantsLocationRequest): DeleteAccessGrantsLocationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes the specified access point.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples) section.
     *
     * The following actions are related to `DeleteAccessPoint`:
     * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
     * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
     * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
     */
    public suspend fun deleteAccessPoint(input: DeleteAccessPointRequest): DeleteAccessPointResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes the specified Object Lambda Access Point.
     *
     * The following actions are related to `DeleteAccessPointForObjectLambda`:
     * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
     * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
     * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
     */
    public suspend fun deleteAccessPointForObjectLambda(input: DeleteAccessPointForObjectLambdaRequest): DeleteAccessPointForObjectLambdaResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes the access point policy for the specified access point.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples) section.
     *
     * The following actions are related to `DeleteAccessPointPolicy`:
     * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
     * + [GetAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
     */
    public suspend fun deleteAccessPointPolicy(input: DeleteAccessPointPolicyRequest): DeleteAccessPointPolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Removes the resource policy for an Object Lambda Access Point.
     *
     * The following actions are related to `DeleteAccessPointPolicyForObjectLambda`:
     * + [GetAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
     * + [PutAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
     */
    public suspend fun deleteAccessPointPolicyForObjectLambda(input: DeleteAccessPointPolicyForObjectLambdaRequest): DeleteAccessPointPolicyForObjectLambdaResponse

    /**
     * This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html) in the *Amazon S3 API Reference*.
     *
     * Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples) section.
     *
     * **Related Resources**
     * + [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
     * + [GetBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
     * + [DeleteObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
     */
    public suspend fun deleteBucket(input: DeleteBucketRequest): DeleteBucketResponse

    /**
     * This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle configuration, see [DeleteBucketLifecycle](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html) in the *Amazon S3 API Reference*.
     *
     * Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
     *
     * To use this operation, you must have permission to perform the `s3-outposts:PutLifecycleConfiguration` action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission to others.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples) section.
     *
     * For more information about object expiration, see [Elements to Describe Lifecycle Actions](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
     *
     * Related actions include:
     * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
     * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
     */
    public suspend fun deleteBucketLifecycleConfiguration(input: DeleteBucketLifecycleConfigurationRequest): DeleteBucketLifecycleConfigurationResponse

    /**
     * This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html) in the *Amazon S3 API Reference*.
     *
     * This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the `s3-outposts:DeleteBucketPolicy` permissions on the specified Outposts bucket and belong to the bucket owner's account to use this action. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
     *
     * If you don't have `DeleteBucketPolicy` permissions, Amazon S3 returns a `403 Access Denied` error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `405 Method Not Allowed` error.
     *
     * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
     *
     * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples) section.
     *
     * The following actions are related to `DeleteBucketPolicy`:
     * + [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
     * + [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
     */
    public suspend fun deleteBucketPolicy(input: DeleteBucketPolicyRequest): DeleteBucketPolicyResponse

    /**
     * This operation deletes an Amazon S3 on Outposts bucket's replication configuration. To delete an S3 bucket's replication configuration, see [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html) in the *Amazon S3 API Reference*.
     *
     * Deletes the replication configuration from the specified S3 on Outposts bucket.
     *
     * To use this operation, you must have permissions to perform the `s3-outposts:PutReplicationConfiguration` action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html) in the *Amazon S3 User Guide*.
     *
     * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html#API_control_DeleteBucketReplication_Examples) section.
     *
     * For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
     *
     * The following operations are related to `DeleteBucketReplication`:
     * + [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
     * + [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
     */
    public suspend fun deleteBucketReplication(input: DeleteBucketReplicationRequest): DeleteBucketReplicationResponse

    /**
     * This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html) in the *Amazon S3 API Reference*.
     *
     * Deletes the tags from the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `PutBucketTagging` action. By default, the bucket owner has this permission and can grant this permission to others.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples) section.
     *
     * The following actions are related to `DeleteBucketTagging`:
     * + [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
     * + [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
     */
    public suspend fun deleteBucketTagging(input: DeleteBucketTaggingRequest): DeleteBucketTaggingResponse

    /**
     * Removes the entire tag set from the specified S3 Batch Operations job.
     *
     * ## Permissions
     * To use the `DeleteJobTagging` operation, you must have permission to perform the `s3:DeleteJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
     * + [PutJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
     */
    public suspend fun deleteJobTagging(input: DeleteJobTaggingRequest): DeleteJobTaggingResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with `DescribeMultiRegionAccessPointOperation`.
     *
     * The following actions are related to `DeleteMultiRegionAccessPoint`:
     * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
     * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
     * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
     * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
     */
    public suspend fun deleteMultiRegionAccessPoint(input: DeleteMultiRegionAccessPointRequest): DeleteMultiRegionAccessPointResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Removes the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
     *
     * Related actions include:
     * + [GetPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
     * + [PutPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
     */
    public suspend fun deletePublicAccessBlock(input: DeletePublicAccessBlockRequest): DeletePublicAccessBlockResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:DeleteStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun deleteStorageLensConfiguration(input: DeleteStorageLensConfigurationRequest): DeleteStorageLensConfigurationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:DeleteStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun deleteStorageLensConfigurationTagging(input: DeleteStorageLensConfigurationTaggingRequest): DeleteStorageLensConfigurationTaggingResponse

    /**
     * Deletes an existing S3 Storage Lens group.
     *
     * To use this operation, you must have the permission to perform the `s3:DeleteStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
     */
    public suspend fun deleteStorageLensGroup(input: DeleteStorageLensGroupRequest): DeleteStorageLensGroupResponse

    /**
     * Retrieves the configuration parameters and status for a Batch Operations job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
     *
     * ## Permissions
     * To use the `DescribeJob` operation, you must have permission to perform the `s3:DescribeJob` action.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
     * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
     * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
     */
    public suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see [Using Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MrapOperations.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `GetMultiRegionAccessPoint`:
     * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
     * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
     * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
     * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
     */
    public suspend fun describeMultiRegionAccessPointOperation(input: DescribeMultiRegionAccessPointOperationRequest): DescribeMultiRegionAccessPointOperationResponse

    /**
     * Dissociates the Amazon Web Services IAM Identity Center instance from the S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:DissociateAccessGrantsIdentityCenter` permission to use this operation.
     *
     * ## Additional Permissions
     * You must have the `sso:DeleteApplication` permission to use this operation.
     */
    public suspend fun dissociateAccessGrantsIdentityCenter(input: DissociateAccessGrantsIdentityCenterRequest): DissociateAccessGrantsIdentityCenterResponse

    /**
     * Get the details of an access grant from your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:GetAccessGrant` permission to use this operation.
     */
    public suspend fun getAccessGrant(input: GetAccessGrantRequest): GetAccessGrantResponse

    /**
     * Retrieves the S3 Access Grants instance for a Region in your account.
     *
     * ## Permissions
     * You must have the `s3:GetAccessGrantsInstance` permission to use this operation.
     *
     * `GetAccessGrantsInstance` is not supported for cross-account access. You can only call the API from the account that owns the S3 Access Grants instance.
     */
    public suspend fun getAccessGrantsInstance(input: GetAccessGrantsInstanceRequest): GetAccessGrantsInstanceResponse

    /**
     * Retrieve the S3 Access Grants instance that contains a particular prefix.
     *
     * ## Permissions
     * You must have the `s3:GetAccessGrantsInstanceForPrefix` permission for the caller account to use this operation.
     *
     * ## Additional Permissions
     * The prefix owner account must grant you the following permissions to their S3 Access Grants instance: `s3:GetAccessGrantsInstanceForPrefix`.
     */
    public suspend fun getAccessGrantsInstanceForPrefix(input: GetAccessGrantsInstanceForPrefixRequest): GetAccessGrantsInstanceForPrefixResponse

    /**
     * Returns the resource policy of the S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:GetAccessGrantsInstanceResourcePolicy` permission to use this operation.
     */
    public suspend fun getAccessGrantsInstanceResourcePolicy(input: GetAccessGrantsInstanceResourcePolicyRequest): GetAccessGrantsInstanceResourcePolicyResponse

    /**
     * Retrieves the details of a particular location registered in your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:GetAccessGrantsLocation` permission to use this operation.
     */
    public suspend fun getAccessGrantsLocation(input: GetAccessGrantsLocationRequest): GetAccessGrantsLocationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns configuration information about the specified access point.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples) section.
     *
     * The following actions are related to `GetAccessPoint`:
     * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
     * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
     * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
     */
    public suspend fun getAccessPoint(input: GetAccessPointRequest): GetAccessPointResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns configuration for an Object Lambda Access Point.
     *
     * The following actions are related to `GetAccessPointConfigurationForObjectLambda`:
     * + [PutAccessPointConfigurationForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html)
     */
    public suspend fun getAccessPointConfigurationForObjectLambda(input: GetAccessPointConfigurationForObjectLambdaRequest): GetAccessPointConfigurationForObjectLambdaResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns configuration information about the specified Object Lambda Access Point
     *
     * The following actions are related to `GetAccessPointForObjectLambda`:
     * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
     * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
     * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
     */
    public suspend fun getAccessPointForObjectLambda(input: GetAccessPointForObjectLambdaRequest): GetAccessPointForObjectLambdaResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns the access point policy associated with the specified access point.
     *
     * The following actions are related to `GetAccessPointPolicy`:
     * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
     * + [DeleteAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
     */
    public suspend fun getAccessPointPolicy(input: GetAccessPointPolicyRequest): GetAccessPointPolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns the resource policy for an Object Lambda Access Point.
     *
     * The following actions are related to `GetAccessPointPolicyForObjectLambda`:
     * + [DeleteAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
     * + [PutAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
     */
    public suspend fun getAccessPointPolicyForObjectLambda(input: GetAccessPointPolicyForObjectLambdaRequest): GetAccessPointPolicyForObjectLambdaResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see [Managing Data Access with Amazon S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun getAccessPointPolicyStatus(input: GetAccessPointPolicyStatusRequest): GetAccessPointPolicyStatusResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns the status of the resource policy associated with an Object Lambda Access Point.
     */
    public suspend fun getAccessPointPolicyStatusForObjectLambda(input: GetAccessPointPolicyStatusForObjectLambdaRequest): GetAccessPointPolicyStatusForObjectLambdaResponse

    /**
     * Gets an Amazon S3 on Outposts bucket. For more information, see [ Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the `s3-outposts:GetBucket` permissions on the specified Outposts bucket and belong to the Outposts bucket owner's account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket.
     *
     * If you don't have `s3-outposts:GetBucket` permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `403 Access Denied` error.
     *
     * The following actions are related to `GetBucket` for Amazon S3 on Outposts:
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples) section.
     * + [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
     * + [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
     * + [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
     */
    public suspend fun getBucket(input: GetBucketRequest): GetBucketResponse

    /**
     * This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html) in the *Amazon S3 API Reference*.
     *
     * Returns the lifecycle configuration information set on the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) and for information about lifecycle configuration, see [ Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3-outposts:GetLifecycleConfiguration` action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see [Permissions Related to Bucket Subresource Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources) and [Managing Access Permissions to Your Amazon S3 Resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples) section.
     *
     * `GetBucketLifecycleConfiguration` has the following special error:
     * + Error code: `NoSuchLifecycleConfiguration`
     *    + Description: The lifecycle configuration does not exist.
     *    + HTTP Status Code: 404 Not Found
     *    + SOAP Fault Code Prefix: Client
     *
     * The following actions are related to `GetBucketLifecycleConfiguration`:
     * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
     * + [DeleteBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
     */
    public suspend fun getBucketLifecycleConfiguration(input: GetBucketLifecycleConfigurationRequest): GetBucketLifecycleConfigurationResponse

    /**
     * This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html) in the *Amazon S3 API Reference*.
     *
     * Returns the policy of a specified Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the `GetBucketPolicy` permissions on the specified bucket and belong to the bucket owner's account in order to use this action.
     *
     * Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. If you don't have `s3-outposts:GetBucketPolicy` permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `403 Access Denied` error.
     *
     * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
     *
     * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples) section.
     *
     * The following actions are related to `GetBucketPolicy`:
     * + [GetObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
     * + [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
     * + [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
     */
    public suspend fun getBucketPolicy(input: GetBucketPolicyRequest): GetBucketPolicyResponse

    /**
     * This operation gets an Amazon S3 on Outposts bucket's replication configuration. To get an S3 bucket's replication configuration, see [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html) in the *Amazon S3 API Reference*.
     *
     * Returns the replication configuration of an S3 on Outposts bucket. For more information about S3 on Outposts, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*. For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
     *
     * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
     *
     * This action requires permissions for the `s3-outposts:GetReplicationConfiguration` action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html) in the *Amazon S3 User Guide*.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html#API_control_GetBucketReplication_Examples) section.
     *
     * If you include the `Filter` element in a replication configuration, you must also include the `DeleteMarkerReplication`, `Status`, and `Priority` elements. The response also returns those elements.
     *
     * For information about S3 on Outposts replication failure reasons, see [Replication failure reasons](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes) in the *Amazon S3 User Guide*.
     *
     * The following operations are related to `GetBucketReplication`:
     * + [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
     * + [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
     */
    public suspend fun getBucketReplication(input: GetBucketReplicationRequest): GetBucketReplicationResponse

    /**
     * This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html) in the *Amazon S3 API Reference*.
     *
     * Returns the tag set associated with the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `GetBucketTagging` action. By default, the bucket owner has this permission and can grant this permission to others.
     *
     * `GetBucketTagging` has the following special error:
     * + Error code: `NoSuchTagSetError`
     *    + Description: There is no tag set associated with the bucket.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples) section.
     *
     * The following actions are related to `GetBucketTagging`:
     * + [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
     * + [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
     */
    public suspend fun getBucketTagging(input: GetBucketTaggingRequest): GetBucketTaggingResponse

    /**
     * This operation returns the versioning state for S3 on Outposts buckets only. To return the versioning state for an S3 bucket, see [GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html) in the *Amazon S3 API Reference*.
     *
     * Returns the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.
     *
     * If you've never set versioning on your bucket, it has no versioning state. In that case, the `GetBucketVersioning` request does not return a versioning state value.
     *
     * For more information about versioning, see [Versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html) in the *Amazon S3 User Guide*.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html#API_control_GetBucketVersioning_Examples) section.
     *
     * The following operations are related to `GetBucketVersioning` for S3 on Outposts.
     * + [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html)
     * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
     * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
     */
    public suspend fun getBucketVersioning(input: GetBucketVersioningRequest): GetBucketVersioningResponse

    /**
     * Returns a temporary access credential from S3 Access Grants to the grantee or client application. The [temporary credential](https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html) is an Amazon Web Services STS token that grants them access to the S3 data.
     *
     * ## Permissions
     * You must have the `s3:GetDataAccess` permission to use this operation.
     *
     * ## Additional Permissions
     * The IAM role that S3 Access Grants assumes must have the following permissions specified in the trust policy when registering the location: `sts:AssumeRole`, for directory users or groups `sts:SetContext`, and for IAM users or roles `sts:SetSourceIdentity`.
     */
    public suspend fun getDataAccess(input: GetDataAccessRequest): GetDataAccessResponse

    /**
     * Returns the tags on an S3 Batch Operations job.
     *
     * ## Permissions
     * To use the `GetJobTagging` operation, you must have permission to perform the `s3:GetJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [PutJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
     * + [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
     */
    public suspend fun getJobTagging(input: GetJobTaggingRequest): GetJobTaggingResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns configuration information about the specified Multi-Region Access Point.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `GetMultiRegionAccessPoint`:
     * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
     * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
     * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
     * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
     */
    public suspend fun getMultiRegionAccessPoint(input: GetMultiRegionAccessPointRequest): GetMultiRegionAccessPointResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns the access control policy of the specified Multi-Region Access Point.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `GetMultiRegionAccessPointPolicy`:
     * + [GetMultiRegionAccessPointPolicyStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
     * + [PutMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
     */
    public suspend fun getMultiRegionAccessPointPolicy(input: GetMultiRegionAccessPointPolicyRequest): GetMultiRegionAccessPointPolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `GetMultiRegionAccessPointPolicyStatus`:
     * + [GetMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
     * + [PutMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
     */
    public suspend fun getMultiRegionAccessPointPolicyStatus(input: GetMultiRegionAccessPointPolicyStatusRequest): GetMultiRegionAccessPointPolicyStatusResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns the routing configuration for a Multi-Region Access Point, indicating which Regions are active or passive.
     *
     * To obtain routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:
     * + `us-east-1`
     * + `us-west-2`
     * + `ap-southeast-2`
     * + `ap-northeast-1`
     * + `eu-west-1`
     */
    public suspend fun getMultiRegionAccessPointRoutes(input: GetMultiRegionAccessPointRoutesRequest): GetMultiRegionAccessPointRoutesResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Retrieves the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
     *
     * Related actions include:
     * + [DeletePublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
     * + [PutPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
     */
    public suspend fun getPublicAccessBlock(input: GetPublicAccessBlockRequest): GetPublicAccessBlockResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Gets the Amazon S3 Storage Lens configuration. For more information, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:GetStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun getStorageLensConfiguration(input: GetStorageLensConfigurationRequest): GetStorageLensConfigurationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:GetStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun getStorageLensConfigurationTagging(input: GetStorageLensConfigurationTaggingRequest): GetStorageLensConfigurationTaggingResponse

    /**
     * Retrieves the Storage Lens group configuration details.
     *
     * To use this operation, you must have the permission to perform the `s3:GetStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
     */
    public suspend fun getStorageLensGroup(input: GetStorageLensGroupRequest): GetStorageLensGroupResponse

    /**
     * Returns the list of access grants in your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:ListAccessGrants` permission to use this operation.
     */
    public suspend fun listAccessGrants(input: ListAccessGrantsRequest): ListAccessGrantsResponse

    /**
     * Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your individual access grants. You can only have one S3 Access Grants instance per Region per account.
     *
     * ## Permissions
     * You must have the `s3:ListAccessGrantsInstances` permission to use this operation.
     */
    public suspend fun listAccessGrantsInstances(input: ListAccessGrantsInstancesRequest): ListAccessGrantsInstancesResponse

    /**
     * Returns a list of the locations registered in your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:ListAccessGrantsLocations` permission to use this operation.
     */
    public suspend fun listAccessGrantsLocations(input: ListAccessGrantsLocationsRequest): ListAccessGrantsLocationsResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns a list of the access points that are owned by the current account that's associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in `maxResults`, whichever is less), the response will include a continuation token that you can use to list the additional access points.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples) section.
     *
     * The following actions are related to `ListAccessPoints`:
     * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
     * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
     * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
     */
    public suspend fun listAccessPoints(input: ListAccessPointsRequest): ListAccessPointsResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there are more access points than what can be returned in one call, the response will include a continuation token that you can use to list the additional access points.
     *
     * The following actions are related to `ListAccessPointsForObjectLambda`:
     * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
     * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
     * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
     */
    public suspend fun listAccessPointsForObjectLambda(input: ListAccessPointsForObjectLambdaRequest): ListAccessPointsForObjectLambdaResponse

    /**
     * Returns a list of the access grants that were given to the caller using S3 Access Grants and that allow the caller to access the S3 data of the Amazon Web Services account specified in the request.
     *
     * ## Permissions
     * You must have the `s3:ListCallerAccessGrants` permission to use this operation.
     */
    public suspend fun listCallerAccessGrants(input: ListCallerAccessGrantsRequest): ListCallerAccessGrantsResponse

    /**
     * Lists current S3 Batch Operations jobs as well as the jobs that have ended within the last 90 days for the Amazon Web Services account making the request. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
     *
     * ## Permissions
     * To use the `ListJobs` operation, you must have permission to perform the `s3:ListJobs` action.
     *
     * Related actions include:
     *
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
     * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
     * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
     */
    public suspend fun listJobs(input: ListJobsRequest): ListJobsResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `ListMultiRegionAccessPoint`:
     * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
     * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
     * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
     * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
     */
    public suspend fun listMultiRegionAccessPoints(input: ListMultiRegionAccessPointsRequest): ListMultiRegionAccessPointsResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and `x-amz-outpost-id` in your request, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples) section.
     */
    public suspend fun listRegionalBuckets(input: ListRegionalBucketsRequest): ListRegionalBucketsResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:ListStorageLensConfigurations` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun listStorageLensConfigurations(input: ListStorageLensConfigurationsRequest): ListStorageLensConfigurationsResponse

    /**
     * Lists all the Storage Lens groups in the specified home Region.
     *
     * To use this operation, you must have the permission to perform the `s3:ListStorageLensGroups` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
     */
    public suspend fun listStorageLensGroups(input: ListStorageLensGroupsRequest): ListStorageLensGroupsResponse

    /**
     * This operation allows you to list all the Amazon Web Services resource tags for a specified resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
     *
     * ## Permissions
     * You must have the `s3:ListTagsForResource` permission to use this operation.
     *
     * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
     *
     * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Updates the resource policy of the S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:PutAccessGrantsInstanceResourcePolicy` permission to use this operation.
     */
    public suspend fun putAccessGrantsInstanceResourcePolicy(input: PutAccessGrantsInstanceResourcePolicyRequest): PutAccessGrantsInstanceResourcePolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Replaces configuration for an Object Lambda Access Point.
     *
     * The following actions are related to `PutAccessPointConfigurationForObjectLambda`:
     * + [GetAccessPointConfigurationForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html)
     */
    public suspend fun putAccessPointConfigurationForObjectLambda(input: PutAccessPointConfigurationForObjectLambdaRequest): PutAccessPointConfigurationForObjectLambdaResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples) section.
     *
     * The following actions are related to `PutAccessPointPolicy`:
     * + [GetAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
     * + [DeleteAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
     */
    public suspend fun putAccessPointPolicy(input: PutAccessPointPolicyRequest): PutAccessPointPolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see [Creating Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `PutAccessPointPolicyForObjectLambda`:
     * + [DeleteAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
     * + [GetAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
     */
    public suspend fun putAccessPointPolicyForObjectLambda(input: PutAccessPointPolicyForObjectLambdaRequest): PutAccessPointPolicyForObjectLambdaResponse

    /**
     * This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html) in the *Amazon S3 API Reference*.
     *
     * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples) section.
     *
     * The following actions are related to `PutBucketLifecycleConfiguration`:
     * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
     * + [DeleteBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
     */
    public suspend fun putBucketLifecycleConfiguration(input: PutBucketLifecycleConfigurationRequest): PutBucketLifecycleConfigurationResponse

    /**
     * This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html) in the *Amazon S3 API Reference*.
     *
     * Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the `PutBucketPolicy` permissions on the specified Outposts bucket and belong to the bucket owner's account in order to use this action.
     *
     * If you don't have `PutBucketPolicy` permissions, Amazon S3 returns a `403 Access Denied` error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `405 Method Not Allowed` error.
     *
     *  As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
     *
     * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples) section.
     *
     * The following actions are related to `PutBucketPolicy`:
     * + [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
     * + [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
     */
    public suspend fun putBucketPolicy(input: PutBucketPolicyRequest): PutBucketPolicyResponse

    /**
     * This action creates an Amazon S3 on Outposts bucket's replication configuration. To create an S3 bucket's replication configuration, see [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html) in the *Amazon S3 API Reference*.
     *
     * Creates a replication configuration or replaces an existing one. For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
     *
     * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
     *
     * Specify the replication configuration in the request body. In the replication configuration, you provide the following information:
     * + The name of the destination bucket or buckets where you want S3 on Outposts to replicate objects
     * + The Identity and Access Management (IAM) role that S3 on Outposts can assume to replicate objects on your behalf
     * + Other relevant information, such as replication rules
     *
     * A replication configuration must include at least one rule and can contain a maximum of 100. Each rule identifies a subset of objects to replicate by filtering the objects in the source Outposts bucket. To choose additional subsets of objects to replicate, add a rule for each subset.
     *
     * To specify a subset of the objects in the source Outposts bucket to apply a replication rule to, add the `Filter` element as a child of the `Rule` element. You can filter objects based on an object key prefix, one or more object tags, or both. When you add the `Filter` element in the configuration, you must also add the following elements: `DeleteMarkerReplication`, `Status`, and `Priority`.
     *
     * Using `PutBucketReplication` on Outposts requires that both the source and destination buckets must have versioning enabled. For information about enabling versioning on a bucket, see [Managing S3 Versioning for your S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsManagingVersioning.html).
     *
     * For information about S3 on Outposts replication failure reasons, see [Replication failure reasons](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes) in the *Amazon S3 User Guide*.
     *
     * **Handling Replication of Encrypted Objects**
     *
     * Outposts buckets are encrypted at all times. All the objects in the source Outposts bucket are encrypted and can be replicated. Also, all the replicas in the destination Outposts bucket are encrypted with the same encryption key as the objects in the source Outposts bucket.
     *
     * **Permissions**
     *
     * To create a `PutBucketReplication` request, you must have `s3-outposts:PutReplicationConfiguration` permissions for the bucket. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html).
     *
     * To perform this operation, the user or role must also have the `iam:CreateRole` and `iam:PassRole` permissions. For more information, see [Granting a user permissions to pass a role to an Amazon Web Services service](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html#API_control_PutBucketReplication_Examples) section.
     *
     * The following operations are related to `PutBucketReplication`:
     * + [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
     * + [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
     */
    public suspend fun putBucketReplication(input: PutBucketReplicationRequest): PutBucketReplicationResponse

    /**
     * This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html) in the *Amazon S3 API Reference*.
     *
     * Sets the tags for an S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     *
     * Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see [Cost allocation and tagging](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html).
     *
     * Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see [ Using cost allocation in Amazon S3 bucket tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html).
     *
     * To use this action, you must have permissions to perform the `s3-outposts:PutBucketTagging` action. The Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see [ Permissions Related to Bucket Subresource Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources) and [Managing access permissions to your Amazon S3 resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
     *
     * `PutBucketTagging` has the following special errors:
     * + Error code: `InvalidTagError`
     *    + Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see [ User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) and [ Amazon Web Services-Generated Cost Allocation Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html).
     * + Error code: `MalformedXMLError`
     *    + Description: The XML provided does not match the schema.
     * + Error code: `OperationAbortedError `
     *    + Description: A conflicting conditional action is currently in progress against this resource. Try again.
     * + Error code: `InternalError`
     *    + Description: The service was unable to apply the provided tag to the bucket.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples) section.
     *
     * The following actions are related to `PutBucketTagging`:
     * + [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
     * + [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
     */
    public suspend fun putBucketTagging(input: PutBucketTaggingRequest): PutBucketTaggingResponse

    /**
     * This operation sets the versioning state for S3 on Outposts buckets only. To set the versioning state for an S3 bucket, see [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html) in the *Amazon S3 API Reference*.
     *
     * Sets the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.
     *
     * You can set the versioning state to one of the following:
     * + **Enabled** - Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique version ID.
     * + **Suspended** - Suspends versioning for the objects in the bucket. All objects added to the bucket receive the version ID `null`.
     *
     * If you've never set versioning on your bucket, it has no versioning state. In that case, a [ GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html) request does not return a versioning state value.
     *
     * When you enable S3 Versioning, for each object in your bucket, you have a current version and zero or more noncurrent versions. You can configure your bucket S3 Lifecycle rules to expire noncurrent versions after a specified time period. For more information, see [ Creating and managing a lifecycle configuration for your S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsLifecycleManaging.html) in the *Amazon S3 User Guide*.
     *
     * If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the version-enabled bucket. For more information, see [Versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html) in the *Amazon S3 User Guide*.
     *
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html#API_control_PutBucketVersioning_Examples) section.
     *
     * The following operations are related to `PutBucketVersioning` for S3 on Outposts.
     * + [GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html)
     * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
     * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
     */
    public suspend fun putBucketVersioning(input: PutBucketVersioningRequest): PutBucketVersioningResponse

    /**
     * Sets the supplied tag-set on an S3 Batch Operations job.
     *
     * A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html), modify that tag set, and use this operation to replace the tag set with the one you modified. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
     *
     * + If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see [Amazon S3 pricing](http://aws.amazon.com/s3/pricing/).
     * + For deleting existing tags for your Batch Operations job, a [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html) request is preferred because it achieves the same result without incurring charges.
     * + A few things to consider about using tags:
     *    + Amazon S3 limits the maximum number of tags to 50 tags per job.
     *    + You can associate up to 50 tags with a job as long as they have unique tag keys.
     *    + A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.
     *    + The key and values are case sensitive.
     *    + For tagging-related restrictions related to characters and encodings, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *Billing and Cost Management User Guide*.
     * ## Permissions
     * To use the `PutJobTagging` operation, you must have permission to perform the `s3:PutJobTagging` action.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
     * + [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
     */
    public suspend fun putJobTagging(input: PutJobTaggingRequest): PutJobTaggingResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.
     *
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
     *
     * The following actions are related to `PutMultiRegionAccessPointPolicy`:
     * + [GetMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
     * + [GetMultiRegionAccessPointPolicyStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
     */
    public suspend fun putMultiRegionAccessPointPolicy(input: PutMultiRegionAccessPointPolicyRequest): PutMultiRegionAccessPointPolicyResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Creates or modifies the `PublicAccessBlock` configuration for an Amazon Web Services account. For this operation, users must have the `s3:PutAccountPublicAccessBlock` permission. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
     *
     * Related actions include:
     * + [GetPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
     * + [DeletePublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
     */
    public suspend fun putPublicAccessBlock(input: PutPublicAccessBlockRequest): PutPublicAccessBlockResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Working with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:PutStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun putStorageLensConfiguration(input: PutStorageLensConfigurationRequest): PutStorageLensConfigurationResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
     *
     * To use this action, you must have permission to perform the `s3:PutStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
     */
    public suspend fun putStorageLensConfigurationTagging(input: PutStorageLensConfigurationTaggingRequest): PutStorageLensConfigurationTaggingResponse

    /**
     * This operation is not supported by directory buckets.
     *
     * Submits an updated route configuration for a Multi-Region Access Point. This API operation updates the routing status for the specified Regions from active to passive, or from passive to active. A value of `0` indicates a passive status, which means that traffic won't be routed to the specified Region. A value of `100` indicates an active status, which means that traffic will be routed to the specified Region. At least one Region must be active at all times.
     *
     * When the routing configuration is changed, any in-progress operations (uploads, copies, deletes, and so on) to formerly active Regions will continue to run to their final completion state (success or failure). The routing configurations of any Regions that aren’t specified remain unchanged.
     *
     * Updated routing configurations might not be immediately applied. It can take up to 2 minutes for your changes to take effect.
     *
     * To submit routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:
     * + `us-east-1`
     * + `us-west-2`
     * + `ap-southeast-2`
     * + `ap-northeast-1`
     * + `eu-west-1`
     */
    public suspend fun submitMultiRegionAccessPointRoutes(input: SubmitMultiRegionAccessPointRoutesRequest): SubmitMultiRegionAccessPointRoutesResponse

    /**
     * Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource.
     *
     * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
     *
     * ## Permissions
     * You must have the `s3:TagResource` permission to use this operation.
     *
     * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This operation removes the specified Amazon Web Services resource tags from an S3 resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
     *
     * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
     *
     * ## Permissions
     * You must have the `s3:UntagResource` permission to use this operation.
     *
     * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the IAM role of a registered location in your S3 Access Grants instance.
     *
     * ## Permissions
     * You must have the `s3:UpdateAccessGrantsLocation` permission to use this operation.
     *
     * ## Additional Permissions
     * You must also have the following permission: `iam:PassRole`
     */
    public suspend fun updateAccessGrantsLocation(input: UpdateAccessGrantsLocationRequest): UpdateAccessGrantsLocationResponse

    /**
     * Updates an existing S3 Batch Operations job's priority. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
     *
     * ## Permissions
     * To use the `UpdateJobPriority` operation, you must have permission to perform the `s3:UpdateJobPriority` action.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
     * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
     * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
     */
    public suspend fun updateJobPriority(input: UpdateJobPriorityRequest): UpdateJobPriorityResponse

    /**
     * Updates the status for the specified job. Use this operation to confirm that you want to run a job or to cancel an existing job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
     *
     * ## Permissions
     * To use the `UpdateJobStatus` operation, you must have permission to perform the `s3:UpdateJobStatus` action.
     *
     * Related actions include:
     * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
     * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
     * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
     * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
     */
    public suspend fun updateJobStatus(input: UpdateJobStatusRequest): UpdateJobStatusResponse

    /**
     * Updates the existing Storage Lens group.
     *
     * To use this operation, you must have the permission to perform the `s3:UpdateStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
     *
     * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
     */
    public suspend fun updateStorageLensGroup(input: UpdateStorageLensGroupRequest): UpdateStorageLensGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun S3ControlClient.withConfig(block: S3ControlClient.Config.Builder.() -> Unit): S3ControlClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultS3ControlClient(newConfig)
}

/**
 * Associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance. Use this action if you want to create access grants for users or groups from your corporate identity directory. First, you must add your corporate identity directory to Amazon Web Services IAM Identity Center. Then, you can associate this IAM Identity Center instance with your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:AssociateAccessGrantsIdentityCenter` permission to use this operation.
 *
 * ## Additional Permissions
 * You must also have the following permissions: `sso:CreateApplication`, `sso:PutApplicationGrant`, and `sso:PutApplicationAuthenticationMethod`.
 */
public suspend inline fun S3ControlClient.associateAccessGrantsIdentityCenter(crossinline block: AssociateAccessGrantsIdentityCenterRequest.Builder.() -> Unit): AssociateAccessGrantsIdentityCenterResponse = associateAccessGrantsIdentityCenter(AssociateAccessGrantsIdentityCenterRequest.Builder().apply(block).build())

/**
 * Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the [CreateAccessGrantsInstance](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html). You must also have registered at least one S3 data location in your S3 Access Grants instance using [CreateAccessGrantsLocation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html).
 *
 * ## Permissions
 * You must have the `s3:CreateAccessGrant` permission to use this operation.
 *
 * ## Additional Permissions
 * For any directory identity - `sso:DescribeInstance` and `sso:DescribeApplication`
 *
 * For directory users - `identitystore:DescribeUser`
 *
 * For directory groups - `identitystore:DescribeGroup`
 */
public suspend inline fun S3ControlClient.createAccessGrant(crossinline block: CreateAccessGrantRequest.Builder.() -> Unit): CreateAccessGrantResponse = createAccessGrant(CreateAccessGrantRequest.Builder().apply(block).build())

/**
 * Creates an S3 Access Grants instance, which serves as a logical grouping for access grants. You can create one S3 Access Grants instance per Region per account.
 *
 * ## Permissions
 * You must have the `s3:CreateAccessGrantsInstance` permission to use this operation.
 *
 * ## Additional Permissions
 * To associate an IAM Identity Center instance with your S3 Access Grants instance, you must also have the `sso:DescribeInstance`, `sso:CreateApplication`, `sso:PutApplicationGrant`, and `sso:PutApplicationAuthenticationMethod` permissions.
 */
public suspend inline fun S3ControlClient.createAccessGrantsInstance(crossinline block: CreateAccessGrantsInstanceRequest.Builder.() -> Unit): CreateAccessGrantsInstanceResponse = createAccessGrantsInstance(CreateAccessGrantsInstanceRequest.Builder().apply(block).build())

/**
 * The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in the same Region as your S3 Access Grants instance. The location can be one of the following:
 * + The default S3 location `s3://`
 * + A bucket - `S3://<bucket-name>`
 * + A bucket and prefix - `S3://<bucket-name>/<prefix>`
 *
 * When you register a location, you must include the IAM role that has permission to manage the S3 location that you are registering. Give S3 Access Grants permission to assume this role [using a policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-location.html). S3 Access Grants assumes this role to manage access to the location and to vend temporary credentials to grantees or client applications.
 *
 * ## Permissions
 * You must have the `s3:CreateAccessGrantsLocation` permission to use this operation.
 *
 * ## Additional Permissions
 * You must also have the following permission for the specified IAM role: `iam:PassRole`
 */
public suspend inline fun S3ControlClient.createAccessGrantsLocation(crossinline block: CreateAccessGrantsLocationRequest.Builder.() -> Unit): CreateAccessGrantsLocationResponse = createAccessGrantsLocation(CreateAccessGrantsLocationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Creates an access point and associates it with the specified bucket. For more information, see [Managing Data Access with Amazon S3 Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
 *
 * S3 on Outposts only supports VPC-style access points.
 *
 * For more information, see [ Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples) section.
 *
 * The following actions are related to `CreateAccessPoint`:
 * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
 * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
 * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
 */
public suspend inline fun S3ControlClient.createAccessPoint(crossinline block: CreateAccessPointRequest.Builder.() -> Unit): CreateAccessPointResponse = createAccessPoint(CreateAccessPointRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Creates an Object Lambda Access Point. For more information, see [Transforming objects with Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `CreateAccessPointForObjectLambda`:
 * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
 * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
 * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.createAccessPointForObjectLambda(crossinline block: CreateAccessPointForObjectLambdaRequest.Builder.() -> Unit): CreateAccessPointForObjectLambdaResponse = createAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see [Create Bucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) in the *Amazon S3 API Reference*.
 *
 * Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
 *
 * Not every string is an acceptable bucket name. For information on bucket naming restrictions, see [Working with Amazon S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules).
 *
 * S3 on Outposts buckets support:
 * + Tags
 * + LifecycleConfigurations for deleting expired objects
 *
 * For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see [ Amazon S3 on Outposts Restrictions and Limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html).
 *
 * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and `x-amz-outpost-id` in your API request, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples) section.
 *
 * The following actions are related to `CreateBucket` for Amazon S3 on Outposts:
 * + [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
 * + [GetBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
 * + [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
 * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
 * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.createBucket(crossinline block: CreateBucketRequest.Builder.() -> Unit): CreateBucketResponse = createBucket(CreateBucketRequest.Builder().apply(block).build())

/**
 * This operation creates an S3 Batch Operations job.
 *
 * You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
 *
 * ## Permissions
 * For information about permissions required to use the Batch Operations, see [Granting permissions for S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-iam-role-policies.html) in the *Amazon S3 User Guide*.
 *
 * Related actions include:
 * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
 * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
 * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
 * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
 * + [JobOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html)
 */
public suspend inline fun S3ControlClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see [Creating Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html) in the *Amazon S3 User Guide*.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with `DescribeMultiRegionAccessPointOperation`.
 *
 * The following actions are related to `CreateMultiRegionAccessPoint`:
 * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
 * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
 * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
 * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
 */
public suspend inline fun S3ControlClient.createMultiRegionAccessPoint(crossinline block: CreateMultiRegionAccessPointRequest.Builder.() -> Unit): CreateMultiRegionAccessPointResponse = createMultiRegionAccessPoint(CreateMultiRegionAccessPointRequest.Builder().apply(block).build())

/**
 * Creates a new S3 Storage Lens group and associates it with the specified Amazon Web Services account ID. An S3 Storage Lens group is a custom grouping of objects based on prefix, suffix, object tags, object size, object age, or a combination of these filters. For each Storage Lens group that you’ve created, you can also optionally add Amazon Web Services resource tags. For more information about S3 Storage Lens groups, see [Working with S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html).
 *
 * To use this operation, you must have the permission to perform the `s3:CreateStorageLensGroup` action. If you’re trying to create a Storage Lens group with Amazon Web Services resource tags, you must also have permission to perform the `s3:TagResource` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
 */
public suspend inline fun S3ControlClient.createStorageLensGroup(crossinline block: CreateStorageLensGroupRequest.Builder.() -> Unit): CreateStorageLensGroupResponse = createStorageLensGroup(CreateStorageLensGroupRequest.Builder().apply(block).build())

/**
 * Deletes the access grant from the S3 Access Grants instance. You cannot undo an access grant deletion and the grantee will no longer have access to the S3 data.
 *
 * ## Permissions
 * You must have the `s3:DeleteAccessGrant` permission to use this operation.
 */
public suspend inline fun S3ControlClient.deleteAccessGrant(crossinline block: DeleteAccessGrantRequest.Builder.() -> Unit): DeleteAccessGrantResponse = deleteAccessGrant(DeleteAccessGrantRequest.Builder().apply(block).build())

/**
 * Deletes your S3 Access Grants instance. You must first delete the access grants and locations before S3 Access Grants can delete the instance. See [DeleteAccessGrant](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html) and [DeleteAccessGrantsLocation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrantsLocation.html). If you have associated an IAM Identity Center instance with your S3 Access Grants instance, you must first dissassociate the Identity Center instance from the S3 Access Grants instance before you can delete the S3 Access Grants instance. See [AssociateAccessGrantsIdentityCenter](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AssociateAccessGrantsIdentityCenter.html) and [DissociateAccessGrantsIdentityCenter](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DissociateAccessGrantsIdentityCenter.html).
 *
 * ## Permissions
 * You must have the `s3:DeleteAccessGrantsInstance` permission to use this operation.
 */
public suspend inline fun S3ControlClient.deleteAccessGrantsInstance(crossinline block: DeleteAccessGrantsInstanceRequest.Builder.() -> Unit): DeleteAccessGrantsInstanceResponse = deleteAccessGrantsInstance(DeleteAccessGrantsInstanceRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy of the S3 Access Grants instance. The resource policy is used to manage cross-account access to your S3 Access Grants instance. By deleting the resource policy, you delete any cross-account permissions to your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:DeleteAccessGrantsInstanceResourcePolicy` permission to use this operation.
 */
public suspend inline fun S3ControlClient.deleteAccessGrantsInstanceResourcePolicy(crossinline block: DeleteAccessGrantsInstanceResourcePolicyRequest.Builder.() -> Unit): DeleteAccessGrantsInstanceResourcePolicyResponse = deleteAccessGrantsInstanceResourcePolicy(DeleteAccessGrantsInstanceResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deregisters a location from your S3 Access Grants instance. You can only delete a location registration from an S3 Access Grants instance if there are no grants associated with this location. See [Delete a grant](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html) for information on how to delete grants. You need to have at least one registered location in your S3 Access Grants instance in order to create access grants.
 *
 * ## Permissions
 * You must have the `s3:DeleteAccessGrantsLocation` permission to use this operation.
 */
public suspend inline fun S3ControlClient.deleteAccessGrantsLocation(crossinline block: DeleteAccessGrantsLocationRequest.Builder.() -> Unit): DeleteAccessGrantsLocationResponse = deleteAccessGrantsLocation(DeleteAccessGrantsLocationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes the specified access point.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples) section.
 *
 * The following actions are related to `DeleteAccessPoint`:
 * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
 * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
 * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
 */
public suspend inline fun S3ControlClient.deleteAccessPoint(crossinline block: DeleteAccessPointRequest.Builder.() -> Unit): DeleteAccessPointResponse = deleteAccessPoint(DeleteAccessPointRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes the specified Object Lambda Access Point.
 *
 * The following actions are related to `DeleteAccessPointForObjectLambda`:
 * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
 * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
 * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.deleteAccessPointForObjectLambda(crossinline block: DeleteAccessPointForObjectLambdaRequest.Builder.() -> Unit): DeleteAccessPointForObjectLambdaResponse = deleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes the access point policy for the specified access point.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples) section.
 *
 * The following actions are related to `DeleteAccessPointPolicy`:
 * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
 * + [GetAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.deleteAccessPointPolicy(crossinline block: DeleteAccessPointPolicyRequest.Builder.() -> Unit): DeleteAccessPointPolicyResponse = deleteAccessPointPolicy(DeleteAccessPointPolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Removes the resource policy for an Object Lambda Access Point.
 *
 * The following actions are related to `DeleteAccessPointPolicyForObjectLambda`:
 * + [GetAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
 * + [PutAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.deleteAccessPointPolicyForObjectLambda(crossinline block: DeleteAccessPointPolicyForObjectLambdaRequest.Builder.() -> Unit): DeleteAccessPointPolicyForObjectLambdaResponse = deleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html) in the *Amazon S3 API Reference*.
 *
 * Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples) section.
 *
 * **Related Resources**
 * + [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
 * + [GetBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
 * + [DeleteObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
 */
public suspend inline fun S3ControlClient.deleteBucket(crossinline block: DeleteBucketRequest.Builder.() -> Unit): DeleteBucketResponse = deleteBucket(DeleteBucketRequest.Builder().apply(block).build())

/**
 * This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle configuration, see [DeleteBucketLifecycle](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html) in the *Amazon S3 API Reference*.
 *
 * Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
 *
 * To use this operation, you must have permission to perform the `s3-outposts:PutLifecycleConfiguration` action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission to others.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples) section.
 *
 * For more information about object expiration, see [Elements to Describe Lifecycle Actions](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
 *
 * Related actions include:
 * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
 * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
 */
public suspend inline fun S3ControlClient.deleteBucketLifecycleConfiguration(crossinline block: DeleteBucketLifecycleConfigurationRequest.Builder.() -> Unit): DeleteBucketLifecycleConfigurationResponse = deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest.Builder().apply(block).build())

/**
 * This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html) in the *Amazon S3 API Reference*.
 *
 * This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the `s3-outposts:DeleteBucketPolicy` permissions on the specified Outposts bucket and belong to the bucket owner's account to use this action. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
 *
 * If you don't have `DeleteBucketPolicy` permissions, Amazon S3 returns a `403 Access Denied` error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `405 Method Not Allowed` error.
 *
 * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
 *
 * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples) section.
 *
 * The following actions are related to `DeleteBucketPolicy`:
 * + [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
 * + [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
 */
public suspend inline fun S3ControlClient.deleteBucketPolicy(crossinline block: DeleteBucketPolicyRequest.Builder.() -> Unit): DeleteBucketPolicyResponse = deleteBucketPolicy(DeleteBucketPolicyRequest.Builder().apply(block).build())

/**
 * This operation deletes an Amazon S3 on Outposts bucket's replication configuration. To delete an S3 bucket's replication configuration, see [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html) in the *Amazon S3 API Reference*.
 *
 * Deletes the replication configuration from the specified S3 on Outposts bucket.
 *
 * To use this operation, you must have permissions to perform the `s3-outposts:PutReplicationConfiguration` action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html) in the *Amazon S3 User Guide*.
 *
 * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html#API_control_DeleteBucketReplication_Examples) section.
 *
 * For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
 *
 * The following operations are related to `DeleteBucketReplication`:
 * + [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
 * + [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
 */
public suspend inline fun S3ControlClient.deleteBucketReplication(crossinline block: DeleteBucketReplicationRequest.Builder.() -> Unit): DeleteBucketReplicationResponse = deleteBucketReplication(DeleteBucketReplicationRequest.Builder().apply(block).build())

/**
 * This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html) in the *Amazon S3 API Reference*.
 *
 * Deletes the tags from the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `PutBucketTagging` action. By default, the bucket owner has this permission and can grant this permission to others.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples) section.
 *
 * The following actions are related to `DeleteBucketTagging`:
 * + [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
 * + [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
 */
public suspend inline fun S3ControlClient.deleteBucketTagging(crossinline block: DeleteBucketTaggingRequest.Builder.() -> Unit): DeleteBucketTaggingResponse = deleteBucketTagging(DeleteBucketTaggingRequest.Builder().apply(block).build())

/**
 * Removes the entire tag set from the specified S3 Batch Operations job.
 *
 * ## Permissions
 * To use the `DeleteJobTagging` operation, you must have permission to perform the `s3:DeleteJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
 * + [PutJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
 */
public suspend inline fun S3ControlClient.deleteJobTagging(crossinline block: DeleteJobTaggingRequest.Builder.() -> Unit): DeleteJobTaggingResponse = deleteJobTagging(DeleteJobTaggingRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with `DescribeMultiRegionAccessPointOperation`.
 *
 * The following actions are related to `DeleteMultiRegionAccessPoint`:
 * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
 * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
 * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
 * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
 */
public suspend inline fun S3ControlClient.deleteMultiRegionAccessPoint(crossinline block: DeleteMultiRegionAccessPointRequest.Builder.() -> Unit): DeleteMultiRegionAccessPointResponse = deleteMultiRegionAccessPoint(DeleteMultiRegionAccessPointRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Removes the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 *
 * Related actions include:
 * + [GetPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
 * + [PutPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
 */
public suspend inline fun S3ControlClient.deletePublicAccessBlock(crossinline block: DeletePublicAccessBlockRequest.Builder.() -> Unit): DeletePublicAccessBlockResponse = deletePublicAccessBlock(DeletePublicAccessBlockRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:DeleteStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.deleteStorageLensConfiguration(crossinline block: DeleteStorageLensConfigurationRequest.Builder.() -> Unit): DeleteStorageLensConfigurationResponse = deleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:DeleteStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.deleteStorageLensConfigurationTagging(crossinline block: DeleteStorageLensConfigurationTaggingRequest.Builder.() -> Unit): DeleteStorageLensConfigurationTaggingResponse = deleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest.Builder().apply(block).build())

/**
 * Deletes an existing S3 Storage Lens group.
 *
 * To use this operation, you must have the permission to perform the `s3:DeleteStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
 */
public suspend inline fun S3ControlClient.deleteStorageLensGroup(crossinline block: DeleteStorageLensGroupRequest.Builder.() -> Unit): DeleteStorageLensGroupResponse = deleteStorageLensGroup(DeleteStorageLensGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration parameters and status for a Batch Operations job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
 *
 * ## Permissions
 * To use the `DescribeJob` operation, you must have permission to perform the `s3:DescribeJob` action.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
 * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
 * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
 */
public suspend inline fun S3ControlClient.describeJob(crossinline block: DescribeJobRequest.Builder.() -> Unit): DescribeJobResponse = describeJob(DescribeJobRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see [Using Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MrapOperations.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `GetMultiRegionAccessPoint`:
 * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
 * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
 * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
 * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
 */
public suspend inline fun S3ControlClient.describeMultiRegionAccessPointOperation(crossinline block: DescribeMultiRegionAccessPointOperationRequest.Builder.() -> Unit): DescribeMultiRegionAccessPointOperationResponse = describeMultiRegionAccessPointOperation(DescribeMultiRegionAccessPointOperationRequest.Builder().apply(block).build())

/**
 * Dissociates the Amazon Web Services IAM Identity Center instance from the S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:DissociateAccessGrantsIdentityCenter` permission to use this operation.
 *
 * ## Additional Permissions
 * You must have the `sso:DeleteApplication` permission to use this operation.
 */
public suspend inline fun S3ControlClient.dissociateAccessGrantsIdentityCenter(crossinline block: DissociateAccessGrantsIdentityCenterRequest.Builder.() -> Unit): DissociateAccessGrantsIdentityCenterResponse = dissociateAccessGrantsIdentityCenter(DissociateAccessGrantsIdentityCenterRequest.Builder().apply(block).build())

/**
 * Get the details of an access grant from your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:GetAccessGrant` permission to use this operation.
 */
public suspend inline fun S3ControlClient.getAccessGrant(crossinline block: GetAccessGrantRequest.Builder.() -> Unit): GetAccessGrantResponse = getAccessGrant(GetAccessGrantRequest.Builder().apply(block).build())

/**
 * Retrieves the S3 Access Grants instance for a Region in your account.
 *
 * ## Permissions
 * You must have the `s3:GetAccessGrantsInstance` permission to use this operation.
 *
 * `GetAccessGrantsInstance` is not supported for cross-account access. You can only call the API from the account that owns the S3 Access Grants instance.
 */
public suspend inline fun S3ControlClient.getAccessGrantsInstance(crossinline block: GetAccessGrantsInstanceRequest.Builder.() -> Unit): GetAccessGrantsInstanceResponse = getAccessGrantsInstance(GetAccessGrantsInstanceRequest.Builder().apply(block).build())

/**
 * Retrieve the S3 Access Grants instance that contains a particular prefix.
 *
 * ## Permissions
 * You must have the `s3:GetAccessGrantsInstanceForPrefix` permission for the caller account to use this operation.
 *
 * ## Additional Permissions
 * The prefix owner account must grant you the following permissions to their S3 Access Grants instance: `s3:GetAccessGrantsInstanceForPrefix`.
 */
public suspend inline fun S3ControlClient.getAccessGrantsInstanceForPrefix(crossinline block: GetAccessGrantsInstanceForPrefixRequest.Builder.() -> Unit): GetAccessGrantsInstanceForPrefixResponse = getAccessGrantsInstanceForPrefix(GetAccessGrantsInstanceForPrefixRequest.Builder().apply(block).build())

/**
 * Returns the resource policy of the S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:GetAccessGrantsInstanceResourcePolicy` permission to use this operation.
 */
public suspend inline fun S3ControlClient.getAccessGrantsInstanceResourcePolicy(crossinline block: GetAccessGrantsInstanceResourcePolicyRequest.Builder.() -> Unit): GetAccessGrantsInstanceResourcePolicyResponse = getAccessGrantsInstanceResourcePolicy(GetAccessGrantsInstanceResourcePolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the details of a particular location registered in your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:GetAccessGrantsLocation` permission to use this operation.
 */
public suspend inline fun S3ControlClient.getAccessGrantsLocation(crossinline block: GetAccessGrantsLocationRequest.Builder.() -> Unit): GetAccessGrantsLocationResponse = getAccessGrantsLocation(GetAccessGrantsLocationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns configuration information about the specified access point.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples) section.
 *
 * The following actions are related to `GetAccessPoint`:
 * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
 * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
 * + [ListAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
 */
public suspend inline fun S3ControlClient.getAccessPoint(crossinline block: GetAccessPointRequest.Builder.() -> Unit): GetAccessPointResponse = getAccessPoint(GetAccessPointRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns configuration for an Object Lambda Access Point.
 *
 * The following actions are related to `GetAccessPointConfigurationForObjectLambda`:
 * + [PutAccessPointConfigurationForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.getAccessPointConfigurationForObjectLambda(crossinline block: GetAccessPointConfigurationForObjectLambdaRequest.Builder.() -> Unit): GetAccessPointConfigurationForObjectLambdaResponse = getAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns configuration information about the specified Object Lambda Access Point
 *
 * The following actions are related to `GetAccessPointForObjectLambda`:
 * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
 * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
 * + [ListAccessPointsForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.getAccessPointForObjectLambda(crossinline block: GetAccessPointForObjectLambdaRequest.Builder.() -> Unit): GetAccessPointForObjectLambdaResponse = getAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns the access point policy associated with the specified access point.
 *
 * The following actions are related to `GetAccessPointPolicy`:
 * + [PutAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
 * + [DeleteAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.getAccessPointPolicy(crossinline block: GetAccessPointPolicyRequest.Builder.() -> Unit): GetAccessPointPolicyResponse = getAccessPointPolicy(GetAccessPointPolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns the resource policy for an Object Lambda Access Point.
 *
 * The following actions are related to `GetAccessPointPolicyForObjectLambda`:
 * + [DeleteAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
 * + [PutAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.getAccessPointPolicyForObjectLambda(crossinline block: GetAccessPointPolicyForObjectLambdaRequest.Builder.() -> Unit): GetAccessPointPolicyForObjectLambdaResponse = getAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see [Managing Data Access with Amazon S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.getAccessPointPolicyStatus(crossinline block: GetAccessPointPolicyStatusRequest.Builder.() -> Unit): GetAccessPointPolicyStatusResponse = getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns the status of the resource policy associated with an Object Lambda Access Point.
 */
public suspend inline fun S3ControlClient.getAccessPointPolicyStatusForObjectLambda(crossinline block: GetAccessPointPolicyStatusForObjectLambdaRequest.Builder.() -> Unit): GetAccessPointPolicyStatusForObjectLambdaResponse = getAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest.Builder().apply(block).build())

/**
 * Gets an Amazon S3 on Outposts bucket. For more information, see [ Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the `s3-outposts:GetBucket` permissions on the specified Outposts bucket and belong to the Outposts bucket owner's account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket.
 *
 * If you don't have `s3-outposts:GetBucket` permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `403 Access Denied` error.
 *
 * The following actions are related to `GetBucket` for Amazon S3 on Outposts:
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples) section.
 * + [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
 * + [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
 * + [DeleteBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
 */
public suspend inline fun S3ControlClient.getBucket(crossinline block: GetBucketRequest.Builder.() -> Unit): GetBucketResponse = getBucket(GetBucketRequest.Builder().apply(block).build())

/**
 * This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html) in the *Amazon S3 API Reference*.
 *
 * Returns the lifecycle configuration information set on the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) and for information about lifecycle configuration, see [ Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3-outposts:GetLifecycleConfiguration` action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see [Permissions Related to Bucket Subresource Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources) and [Managing Access Permissions to Your Amazon S3 Resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples) section.
 *
 * `GetBucketLifecycleConfiguration` has the following special error:
 * + Error code: `NoSuchLifecycleConfiguration`
 *    + Description: The lifecycle configuration does not exist.
 *    + HTTP Status Code: 404 Not Found
 *    + SOAP Fault Code Prefix: Client
 *
 * The following actions are related to `GetBucketLifecycleConfiguration`:
 * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
 * + [DeleteBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
 */
public suspend inline fun S3ControlClient.getBucketLifecycleConfiguration(crossinline block: GetBucketLifecycleConfigurationRequest.Builder.() -> Unit): GetBucketLifecycleConfigurationResponse = getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest.Builder().apply(block).build())

/**
 * This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html) in the *Amazon S3 API Reference*.
 *
 * Returns the policy of a specified Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the `GetBucketPolicy` permissions on the specified bucket and belong to the bucket owner's account in order to use this action.
 *
 * Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. If you don't have `s3-outposts:GetBucketPolicy` permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `403 Access Denied` error.
 *
 * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
 *
 * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples) section.
 *
 * The following actions are related to `GetBucketPolicy`:
 * + [GetObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
 * + [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
 * + [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
 */
public suspend inline fun S3ControlClient.getBucketPolicy(crossinline block: GetBucketPolicyRequest.Builder.() -> Unit): GetBucketPolicyResponse = getBucketPolicy(GetBucketPolicyRequest.Builder().apply(block).build())

/**
 * This operation gets an Amazon S3 on Outposts bucket's replication configuration. To get an S3 bucket's replication configuration, see [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html) in the *Amazon S3 API Reference*.
 *
 * Returns the replication configuration of an S3 on Outposts bucket. For more information about S3 on Outposts, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*. For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
 *
 * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
 *
 * This action requires permissions for the `s3-outposts:GetReplicationConfiguration` action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html) in the *Amazon S3 User Guide*.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html#API_control_GetBucketReplication_Examples) section.
 *
 * If you include the `Filter` element in a replication configuration, you must also include the `DeleteMarkerReplication`, `Status`, and `Priority` elements. The response also returns those elements.
 *
 * For information about S3 on Outposts replication failure reasons, see [Replication failure reasons](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes) in the *Amazon S3 User Guide*.
 *
 * The following operations are related to `GetBucketReplication`:
 * + [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
 * + [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
 */
public suspend inline fun S3ControlClient.getBucketReplication(crossinline block: GetBucketReplicationRequest.Builder.() -> Unit): GetBucketReplicationResponse = getBucketReplication(GetBucketReplicationRequest.Builder().apply(block).build())

/**
 * This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html) in the *Amazon S3 API Reference*.
 *
 * Returns the tag set associated with the Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `GetBucketTagging` action. By default, the bucket owner has this permission and can grant this permission to others.
 *
 * `GetBucketTagging` has the following special error:
 * + Error code: `NoSuchTagSetError`
 *    + Description: There is no tag set associated with the bucket.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples) section.
 *
 * The following actions are related to `GetBucketTagging`:
 * + [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
 * + [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
 */
public suspend inline fun S3ControlClient.getBucketTagging(crossinline block: GetBucketTaggingRequest.Builder.() -> Unit): GetBucketTaggingResponse = getBucketTagging(GetBucketTaggingRequest.Builder().apply(block).build())

/**
 * This operation returns the versioning state for S3 on Outposts buckets only. To return the versioning state for an S3 bucket, see [GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html) in the *Amazon S3 API Reference*.
 *
 * Returns the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.
 *
 * If you've never set versioning on your bucket, it has no versioning state. In that case, the `GetBucketVersioning` request does not return a versioning state value.
 *
 * For more information about versioning, see [Versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html) in the *Amazon S3 User Guide*.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html#API_control_GetBucketVersioning_Examples) section.
 *
 * The following operations are related to `GetBucketVersioning` for S3 on Outposts.
 * + [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html)
 * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
 * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
 */
public suspend inline fun S3ControlClient.getBucketVersioning(crossinline block: GetBucketVersioningRequest.Builder.() -> Unit): GetBucketVersioningResponse = getBucketVersioning(GetBucketVersioningRequest.Builder().apply(block).build())

/**
 * Returns a temporary access credential from S3 Access Grants to the grantee or client application. The [temporary credential](https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html) is an Amazon Web Services STS token that grants them access to the S3 data.
 *
 * ## Permissions
 * You must have the `s3:GetDataAccess` permission to use this operation.
 *
 * ## Additional Permissions
 * The IAM role that S3 Access Grants assumes must have the following permissions specified in the trust policy when registering the location: `sts:AssumeRole`, for directory users or groups `sts:SetContext`, and for IAM users or roles `sts:SetSourceIdentity`.
 */
public suspend inline fun S3ControlClient.getDataAccess(crossinline block: GetDataAccessRequest.Builder.() -> Unit): GetDataAccessResponse = getDataAccess(GetDataAccessRequest.Builder().apply(block).build())

/**
 * Returns the tags on an S3 Batch Operations job.
 *
 * ## Permissions
 * To use the `GetJobTagging` operation, you must have permission to perform the `s3:GetJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [PutJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
 * + [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
 */
public suspend inline fun S3ControlClient.getJobTagging(crossinline block: GetJobTaggingRequest.Builder.() -> Unit): GetJobTaggingResponse = getJobTagging(GetJobTaggingRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns configuration information about the specified Multi-Region Access Point.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `GetMultiRegionAccessPoint`:
 * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
 * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
 * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
 * + [ListMultiRegionAccessPoints](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
 */
public suspend inline fun S3ControlClient.getMultiRegionAccessPoint(crossinline block: GetMultiRegionAccessPointRequest.Builder.() -> Unit): GetMultiRegionAccessPointResponse = getMultiRegionAccessPoint(GetMultiRegionAccessPointRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns the access control policy of the specified Multi-Region Access Point.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `GetMultiRegionAccessPointPolicy`:
 * + [GetMultiRegionAccessPointPolicyStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
 * + [PutMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.getMultiRegionAccessPointPolicy(crossinline block: GetMultiRegionAccessPointPolicyRequest.Builder.() -> Unit): GetMultiRegionAccessPointPolicyResponse = getMultiRegionAccessPointPolicy(GetMultiRegionAccessPointPolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `GetMultiRegionAccessPointPolicyStatus`:
 * + [GetMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
 * + [PutMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.getMultiRegionAccessPointPolicyStatus(crossinline block: GetMultiRegionAccessPointPolicyStatusRequest.Builder.() -> Unit): GetMultiRegionAccessPointPolicyStatusResponse = getMultiRegionAccessPointPolicyStatus(GetMultiRegionAccessPointPolicyStatusRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns the routing configuration for a Multi-Region Access Point, indicating which Regions are active or passive.
 *
 * To obtain routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:
 * + `us-east-1`
 * + `us-west-2`
 * + `ap-southeast-2`
 * + `ap-northeast-1`
 * + `eu-west-1`
 */
public suspend inline fun S3ControlClient.getMultiRegionAccessPointRoutes(crossinline block: GetMultiRegionAccessPointRoutesRequest.Builder.() -> Unit): GetMultiRegionAccessPointRoutesResponse = getMultiRegionAccessPointRoutes(GetMultiRegionAccessPointRoutesRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Retrieves the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 *
 * Related actions include:
 * + [DeletePublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
 * + [PutPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
 */
public suspend inline fun S3ControlClient.getPublicAccessBlock(crossinline block: GetPublicAccessBlockRequest.Builder.() -> Unit): GetPublicAccessBlockResponse = getPublicAccessBlock(GetPublicAccessBlockRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Gets the Amazon S3 Storage Lens configuration. For more information, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:GetStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.getStorageLensConfiguration(crossinline block: GetStorageLensConfigurationRequest.Builder.() -> Unit): GetStorageLensConfigurationResponse = getStorageLensConfiguration(GetStorageLensConfigurationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:GetStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.getStorageLensConfigurationTagging(crossinline block: GetStorageLensConfigurationTaggingRequest.Builder.() -> Unit): GetStorageLensConfigurationTaggingResponse = getStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest.Builder().apply(block).build())

/**
 * Retrieves the Storage Lens group configuration details.
 *
 * To use this operation, you must have the permission to perform the `s3:GetStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
 */
public suspend inline fun S3ControlClient.getStorageLensGroup(crossinline block: GetStorageLensGroupRequest.Builder.() -> Unit): GetStorageLensGroupResponse = getStorageLensGroup(GetStorageLensGroupRequest.Builder().apply(block).build())

/**
 * Returns the list of access grants in your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:ListAccessGrants` permission to use this operation.
 */
public suspend inline fun S3ControlClient.listAccessGrants(crossinline block: ListAccessGrantsRequest.Builder.() -> Unit): ListAccessGrantsResponse = listAccessGrants(ListAccessGrantsRequest.Builder().apply(block).build())

/**
 * Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your individual access grants. You can only have one S3 Access Grants instance per Region per account.
 *
 * ## Permissions
 * You must have the `s3:ListAccessGrantsInstances` permission to use this operation.
 */
public suspend inline fun S3ControlClient.listAccessGrantsInstances(crossinline block: ListAccessGrantsInstancesRequest.Builder.() -> Unit): ListAccessGrantsInstancesResponse = listAccessGrantsInstances(ListAccessGrantsInstancesRequest.Builder().apply(block).build())

/**
 * Returns a list of the locations registered in your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:ListAccessGrantsLocations` permission to use this operation.
 */
public suspend inline fun S3ControlClient.listAccessGrantsLocations(crossinline block: ListAccessGrantsLocationsRequest.Builder.() -> Unit): ListAccessGrantsLocationsResponse = listAccessGrantsLocations(ListAccessGrantsLocationsRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns a list of the access points that are owned by the current account that's associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in `maxResults`, whichever is less), the response will include a continuation token that you can use to list the additional access points.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples) section.
 *
 * The following actions are related to `ListAccessPoints`:
 * + [CreateAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
 * + [DeleteAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
 * + [GetAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
 */
public suspend inline fun S3ControlClient.listAccessPoints(crossinline block: ListAccessPointsRequest.Builder.() -> Unit): ListAccessPointsResponse = listAccessPoints(ListAccessPointsRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there are more access points than what can be returned in one call, the response will include a continuation token that you can use to list the additional access points.
 *
 * The following actions are related to `ListAccessPointsForObjectLambda`:
 * + [CreateAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
 * + [DeleteAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
 * + [GetAccessPointForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.listAccessPointsForObjectLambda(crossinline block: ListAccessPointsForObjectLambdaRequest.Builder.() -> Unit): ListAccessPointsForObjectLambdaResponse = listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest.Builder().apply(block).build())

/**
 * Returns a list of the access grants that were given to the caller using S3 Access Grants and that allow the caller to access the S3 data of the Amazon Web Services account specified in the request.
 *
 * ## Permissions
 * You must have the `s3:ListCallerAccessGrants` permission to use this operation.
 */
public suspend inline fun S3ControlClient.listCallerAccessGrants(crossinline block: ListCallerAccessGrantsRequest.Builder.() -> Unit): ListCallerAccessGrantsResponse = listCallerAccessGrants(ListCallerAccessGrantsRequest.Builder().apply(block).build())

/**
 * Lists current S3 Batch Operations jobs as well as the jobs that have ended within the last 90 days for the Amazon Web Services account making the request. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
 *
 * ## Permissions
 * To use the `ListJobs` operation, you must have permission to perform the `s3:ListJobs` action.
 *
 * Related actions include:
 *
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
 * + [UpdateJobPriority](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
 * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
 */
public suspend inline fun S3ControlClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `ListMultiRegionAccessPoint`:
 * + [CreateMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
 * + [DeleteMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
 * + [DescribeMultiRegionAccessPointOperation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
 * + [GetMultiRegionAccessPoint](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
 */
public suspend inline fun S3ControlClient.listMultiRegionAccessPoints(crossinline block: ListMultiRegionAccessPointsRequest.Builder.() -> Unit): ListMultiRegionAccessPointsResponse = listMultiRegionAccessPoints(ListMultiRegionAccessPointsRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and `x-amz-outpost-id` in your request, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples) section.
 */
public suspend inline fun S3ControlClient.listRegionalBuckets(crossinline block: ListRegionalBucketsRequest.Builder.() -> Unit): ListRegionalBucketsResponse = listRegionalBuckets(ListRegionalBucketsRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:ListStorageLensConfigurations` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.listStorageLensConfigurations(crossinline block: ListStorageLensConfigurationsRequest.Builder.() -> Unit): ListStorageLensConfigurationsResponse = listStorageLensConfigurations(ListStorageLensConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists all the Storage Lens groups in the specified home Region.
 *
 * To use this operation, you must have the permission to perform the `s3:ListStorageLensGroups` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
 */
public suspend inline fun S3ControlClient.listStorageLensGroups(crossinline block: ListStorageLensGroupsRequest.Builder.() -> Unit): ListStorageLensGroupsResponse = listStorageLensGroups(ListStorageLensGroupsRequest.Builder().apply(block).build())

/**
 * This operation allows you to list all the Amazon Web Services resource tags for a specified resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
 *
 * ## Permissions
 * You must have the `s3:ListTagsForResource` permission to use this operation.
 *
 * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
 *
 * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
 */
public suspend inline fun S3ControlClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Updates the resource policy of the S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:PutAccessGrantsInstanceResourcePolicy` permission to use this operation.
 */
public suspend inline fun S3ControlClient.putAccessGrantsInstanceResourcePolicy(crossinline block: PutAccessGrantsInstanceResourcePolicyRequest.Builder.() -> Unit): PutAccessGrantsInstanceResourcePolicyResponse = putAccessGrantsInstanceResourcePolicy(PutAccessGrantsInstanceResourcePolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Replaces configuration for an Object Lambda Access Point.
 *
 * The following actions are related to `PutAccessPointConfigurationForObjectLambda`:
 * + [GetAccessPointConfigurationForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.putAccessPointConfigurationForObjectLambda(crossinline block: PutAccessPointConfigurationForObjectLambdaRequest.Builder.() -> Unit): PutAccessPointConfigurationForObjectLambdaResponse = putAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples) section.
 *
 * The following actions are related to `PutAccessPointPolicy`:
 * + [GetAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
 * + [DeleteAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
 */
public suspend inline fun S3ControlClient.putAccessPointPolicy(crossinline block: PutAccessPointPolicyRequest.Builder.() -> Unit): PutAccessPointPolicyResponse = putAccessPointPolicy(PutAccessPointPolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see [Creating Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `PutAccessPointPolicyForObjectLambda`:
 * + [DeleteAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
 * + [GetAccessPointPolicyForObjectLambda](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
 */
public suspend inline fun S3ControlClient.putAccessPointPolicyForObjectLambda(crossinline block: PutAccessPointPolicyForObjectLambdaRequest.Builder.() -> Unit): PutAccessPointPolicyForObjectLambdaResponse = putAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest.Builder().apply(block).build())

/**
 * This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html) in the *Amazon S3 API Reference*.
 *
 * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples) section.
 *
 * The following actions are related to `PutBucketLifecycleConfiguration`:
 * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
 * + [DeleteBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
 */
public suspend inline fun S3ControlClient.putBucketLifecycleConfiguration(crossinline block: PutBucketLifecycleConfigurationRequest.Builder.() -> Unit): PutBucketLifecycleConfigurationResponse = putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest.Builder().apply(block).build())

/**
 * This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see [PutBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html) in the *Amazon S3 API Reference*.
 *
 * Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the `PutBucketPolicy` permissions on the specified Outposts bucket and belong to the bucket owner's account in order to use this action.
 *
 * If you don't have `PutBucketPolicy` permissions, Amazon S3 returns a `403 Access Denied` error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a `405 Method Not Allowed` error.
 *
 *  As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.
 *
 * For more information about bucket policies, see [Using Bucket Policies and User Policies](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples) section.
 *
 * The following actions are related to `PutBucketPolicy`:
 * + [GetBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
 * + [DeleteBucketPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
 */
public suspend inline fun S3ControlClient.putBucketPolicy(crossinline block: PutBucketPolicyRequest.Builder.() -> Unit): PutBucketPolicyResponse = putBucketPolicy(PutBucketPolicyRequest.Builder().apply(block).build())

/**
 * This action creates an Amazon S3 on Outposts bucket's replication configuration. To create an S3 bucket's replication configuration, see [PutBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html) in the *Amazon S3 API Reference*.
 *
 * Creates a replication configuration or replaces an existing one. For information about S3 replication on Outposts configuration, see [Replicating objects for S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html) in the *Amazon S3 User Guide*.
 *
 * It can take a while to propagate `PUT` or `DELETE` requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a `GET` request soon after a `PUT` or `DELETE` request might return a more recent result than what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.
 *
 * Specify the replication configuration in the request body. In the replication configuration, you provide the following information:
 * + The name of the destination bucket or buckets where you want S3 on Outposts to replicate objects
 * + The Identity and Access Management (IAM) role that S3 on Outposts can assume to replicate objects on your behalf
 * + Other relevant information, such as replication rules
 *
 * A replication configuration must include at least one rule and can contain a maximum of 100. Each rule identifies a subset of objects to replicate by filtering the objects in the source Outposts bucket. To choose additional subsets of objects to replicate, add a rule for each subset.
 *
 * To specify a subset of the objects in the source Outposts bucket to apply a replication rule to, add the `Filter` element as a child of the `Rule` element. You can filter objects based on an object key prefix, one or more object tags, or both. When you add the `Filter` element in the configuration, you must also add the following elements: `DeleteMarkerReplication`, `Status`, and `Priority`.
 *
 * Using `PutBucketReplication` on Outposts requires that both the source and destination buckets must have versioning enabled. For information about enabling versioning on a bucket, see [Managing S3 Versioning for your S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsManagingVersioning.html).
 *
 * For information about S3 on Outposts replication failure reasons, see [Replication failure reasons](https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes) in the *Amazon S3 User Guide*.
 *
 * **Handling Replication of Encrypted Objects**
 *
 * Outposts buckets are encrypted at all times. All the objects in the source Outposts bucket are encrypted and can be replicated. Also, all the replicas in the destination Outposts bucket are encrypted with the same encryption key as the objects in the source Outposts bucket.
 *
 * **Permissions**
 *
 * To create a `PutBucketReplication` request, you must have `s3-outposts:PutReplicationConfiguration` permissions for the bucket. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see [Setting up IAM with S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html) and [Managing access to S3 on Outposts buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html).
 *
 * To perform this operation, the user or role must also have the `iam:CreateRole` and `iam:PassRole` permissions. For more information, see [Granting a user permissions to pass a role to an Amazon Web Services service](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html#API_control_PutBucketReplication_Examples) section.
 *
 * The following operations are related to `PutBucketReplication`:
 * + [GetBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
 * + [DeleteBucketReplication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
 */
public suspend inline fun S3ControlClient.putBucketReplication(crossinline block: PutBucketReplicationRequest.Builder.() -> Unit): PutBucketReplicationResponse = putBucketReplication(PutBucketReplicationRequest.Builder().apply(block).build())

/**
 * This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see [PutBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html) in the *Amazon S3 API Reference*.
 *
 * Sets the tags for an S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
 *
 * Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see [Cost allocation and tagging](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html).
 *
 * Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see [ Using cost allocation in Amazon S3 bucket tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html).
 *
 * To use this action, you must have permissions to perform the `s3-outposts:PutBucketTagging` action. The Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see [ Permissions Related to Bucket Subresource Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources) and [Managing access permissions to your Amazon S3 resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
 *
 * `PutBucketTagging` has the following special errors:
 * + Error code: `InvalidTagError`
 *    + Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see [ User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) and [ Amazon Web Services-Generated Cost Allocation Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html).
 * + Error code: `MalformedXMLError`
 *    + Description: The XML provided does not match the schema.
 * + Error code: `OperationAbortedError `
 *    + Description: A conflicting conditional action is currently in progress against this resource. Try again.
 * + Error code: `InternalError`
 *    + Description: The service was unable to apply the provided tag to the bucket.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples) section.
 *
 * The following actions are related to `PutBucketTagging`:
 * + [GetBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
 * + [DeleteBucketTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
 */
public suspend inline fun S3ControlClient.putBucketTagging(crossinline block: PutBucketTaggingRequest.Builder.() -> Unit): PutBucketTaggingResponse = putBucketTagging(PutBucketTaggingRequest.Builder().apply(block).build())

/**
 * This operation sets the versioning state for S3 on Outposts buckets only. To set the versioning state for an S3 bucket, see [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html) in the *Amazon S3 API Reference*.
 *
 * Sets the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.
 *
 * You can set the versioning state to one of the following:
 * + **Enabled** - Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique version ID.
 * + **Suspended** - Suspends versioning for the objects in the bucket. All objects added to the bucket receive the version ID `null`.
 *
 * If you've never set versioning on your bucket, it has no versioning state. In that case, a [ GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html) request does not return a versioning state value.
 *
 * When you enable S3 Versioning, for each object in your bucket, you have a current version and zero or more noncurrent versions. You can configure your bucket S3 Lifecycle rules to expire noncurrent versions after a specified time period. For more information, see [ Creating and managing a lifecycle configuration for your S3 on Outposts bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsLifecycleManaging.html) in the *Amazon S3 User Guide*.
 *
 * If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the version-enabled bucket. For more information, see [Versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html) in the *Amazon S3 User Guide*.
 *
 * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of `x-amz-outpost-id` to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of `s3-control`. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the `x-amz-outpost-id` derived by using the access point ARN, see the [Examples](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html#API_control_PutBucketVersioning_Examples) section.
 *
 * The following operations are related to `PutBucketVersioning` for S3 on Outposts.
 * + [GetBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html)
 * + [PutBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
 * + [GetBucketLifecycleConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
 */
public suspend inline fun S3ControlClient.putBucketVersioning(crossinline block: PutBucketVersioningRequest.Builder.() -> Unit): PutBucketVersioningResponse = putBucketVersioning(PutBucketVersioningRequest.Builder().apply(block).build())

/**
 * Sets the supplied tag-set on an S3 Batch Operations job.
 *
 * A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html), modify that tag set, and use this operation to replace the tag set with the one you modified. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
 *
 * + If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see [Amazon S3 pricing](http://aws.amazon.com/s3/pricing/).
 * + For deleting existing tags for your Batch Operations job, a [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html) request is preferred because it achieves the same result without incurring charges.
 * + A few things to consider about using tags:
 *    + Amazon S3 limits the maximum number of tags to 50 tags per job.
 *    + You can associate up to 50 tags with a job as long as they have unique tag keys.
 *    + A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.
 *    + The key and values are case sensitive.
 *    + For tagging-related restrictions related to characters and encodings, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *Billing and Cost Management User Guide*.
 * ## Permissions
 * To use the `PutJobTagging` operation, you must have permission to perform the `s3:PutJobTagging` action.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [GetJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
 * + [DeleteJobTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
 */
public suspend inline fun S3ControlClient.putJobTagging(crossinline block: PutJobTaggingRequest.Builder.() -> Unit): PutJobTaggingResponse = putJobTagging(PutJobTaggingRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.
 *
 * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see [Multi-Region Access Point restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html) in the *Amazon S3 User Guide*.
 *
 * The following actions are related to `PutMultiRegionAccessPointPolicy`:
 * + [GetMultiRegionAccessPointPolicy](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
 * + [GetMultiRegionAccessPointPolicyStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
 */
public suspend inline fun S3ControlClient.putMultiRegionAccessPointPolicy(crossinline block: PutMultiRegionAccessPointPolicyRequest.Builder.() -> Unit): PutMultiRegionAccessPointPolicyResponse = putMultiRegionAccessPointPolicy(PutMultiRegionAccessPointPolicyRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Creates or modifies the `PublicAccessBlock` configuration for an Amazon Web Services account. For this operation, users must have the `s3:PutAccountPublicAccessBlock` permission. For more information, see [ Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 *
 * Related actions include:
 * + [GetPublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
 * + [DeletePublicAccessBlock](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
 */
public suspend inline fun S3ControlClient.putPublicAccessBlock(crossinline block: PutPublicAccessBlockRequest.Builder.() -> Unit): PutPublicAccessBlockResponse = putPublicAccessBlock(PutPublicAccessBlockRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Working with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:PutStorageLensConfiguration` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.putStorageLensConfiguration(crossinline block: PutStorageLensConfigurationRequest.Builder.() -> Unit): PutStorageLensConfigurationResponse = putStorageLensConfiguration(PutStorageLensConfigurationRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens ](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html) in the *Amazon S3 User Guide*.
 *
 * To use this action, you must have permission to perform the `s3:PutStorageLensConfigurationTagging` action. For more information, see [Setting permissions to use Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html) in the *Amazon S3 User Guide*.
 */
public suspend inline fun S3ControlClient.putStorageLensConfigurationTagging(crossinline block: PutStorageLensConfigurationTaggingRequest.Builder.() -> Unit): PutStorageLensConfigurationTaggingResponse = putStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest.Builder().apply(block).build())

/**
 * This operation is not supported by directory buckets.
 *
 * Submits an updated route configuration for a Multi-Region Access Point. This API operation updates the routing status for the specified Regions from active to passive, or from passive to active. A value of `0` indicates a passive status, which means that traffic won't be routed to the specified Region. A value of `100` indicates an active status, which means that traffic will be routed to the specified Region. At least one Region must be active at all times.
 *
 * When the routing configuration is changed, any in-progress operations (uploads, copies, deletes, and so on) to formerly active Regions will continue to run to their final completion state (success or failure). The routing configurations of any Regions that aren’t specified remain unchanged.
 *
 * Updated routing configurations might not be immediately applied. It can take up to 2 minutes for your changes to take effect.
 *
 * To submit routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:
 * + `us-east-1`
 * + `us-west-2`
 * + `ap-southeast-2`
 * + `ap-northeast-1`
 * + `eu-west-1`
 */
public suspend inline fun S3ControlClient.submitMultiRegionAccessPointRoutes(crossinline block: SubmitMultiRegionAccessPointRoutesRequest.Builder.() -> Unit): SubmitMultiRegionAccessPointRoutesResponse = submitMultiRegionAccessPointRoutes(SubmitMultiRegionAccessPointRoutesRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource.
 *
 * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
 *
 * ## Permissions
 * You must have the `s3:TagResource` permission to use this operation.
 *
 * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
 */
public suspend inline fun S3ControlClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This operation removes the specified Amazon Web Services resource tags from an S3 resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
 *
 * This operation is only supported for [S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html) and for [S3 Access Grants](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html). The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.
 *
 * ## Permissions
 * You must have the `s3:UntagResource` permission to use this operation.
 *
 * For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about S3 Tagging errors, see [List of Amazon S3 Tagging error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
 */
public suspend inline fun S3ControlClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the IAM role of a registered location in your S3 Access Grants instance.
 *
 * ## Permissions
 * You must have the `s3:UpdateAccessGrantsLocation` permission to use this operation.
 *
 * ## Additional Permissions
 * You must also have the following permission: `iam:PassRole`
 */
public suspend inline fun S3ControlClient.updateAccessGrantsLocation(crossinline block: UpdateAccessGrantsLocationRequest.Builder.() -> Unit): UpdateAccessGrantsLocationResponse = updateAccessGrantsLocation(UpdateAccessGrantsLocationRequest.Builder().apply(block).build())

/**
 * Updates an existing S3 Batch Operations job's priority. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
 *
 * ## Permissions
 * To use the `UpdateJobPriority` operation, you must have permission to perform the `s3:UpdateJobPriority` action.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
 * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
 * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
 */
public suspend inline fun S3ControlClient.updateJobPriority(crossinline block: UpdateJobPriorityRequest.Builder.() -> Unit): UpdateJobPriorityResponse = updateJobPriority(UpdateJobPriorityRequest.Builder().apply(block).build())

/**
 * Updates the status for the specified job. Use this operation to confirm that you want to run a job or to cancel an existing job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
 *
 * ## Permissions
 * To use the `UpdateJobStatus` operation, you must have permission to perform the `s3:UpdateJobStatus` action.
 *
 * Related actions include:
 * + [CreateJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
 * + [ListJobs](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
 * + [DescribeJob](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
 * + [UpdateJobStatus](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
 */
public suspend inline fun S3ControlClient.updateJobStatus(crossinline block: UpdateJobStatusRequest.Builder.() -> Unit): UpdateJobStatusResponse = updateJobStatus(UpdateJobStatusRequest.Builder().apply(block).build())

/**
 * Updates the existing Storage Lens group.
 *
 * To use this operation, you must have the permission to perform the `s3:UpdateStorageLensGroup` action. For more information about the required Storage Lens Groups permissions, see [Setting account permissions to use S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
 *
 * For information about Storage Lens groups errors, see [List of Amazon S3 Storage Lens error codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
 */
public suspend inline fun S3ControlClient.updateStorageLensGroup(crossinline block: UpdateStorageLensGroupRequest.Builder.() -> Unit): UpdateStorageLensGroupResponse = updateStorageLensGroup(UpdateStorageLensGroupRequest.Builder().apply(block).build())
