/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3control.serde;

import aws.sdk.kotlin.services.s3control.model.AccountLevel;
import aws.sdk.kotlin.services.s3control.serde.ActivityMetricsDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.AdvancedCostOptimizationMetricsDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.AdvancedDataProtectionMetricsDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.BucketLevelDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.DetailedStatusCodesMetricsDocumentDeserializerKt;
import aws.sdk.kotlin.services.s3control.serde.StorageLensGroupLevelDocumentDeserializerKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"deserializeAccountLevelDocument", "Laws/sdk/kotlin/services/s3control/model/AccountLevel;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlTagReader;", "s3control"})
public final class AccountLevelDocumentDeserializerKt {
    @NotNull
    public static final AccountLevel deserializeAccountLevelDocument(@NotNull XmlTagReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        AccountLevel.Builder builder = new AccountLevel.Builder();
        while (reader.nextTag() != null) {
            XmlTagReader curr;
            switch (curr.getTagName()) {
                case "ActivityMetrics": {
                    builder.setActivityMetrics(ActivityMetricsDocumentDeserializerKt.deserializeActivityMetricsDocument(curr));
                    break;
                }
                case "BucketLevel": {
                    builder.setBucketLevel(BucketLevelDocumentDeserializerKt.deserializeBucketLevelDocument(curr));
                    break;
                }
                case "AdvancedCostOptimizationMetrics": {
                    builder.setAdvancedCostOptimizationMetrics(AdvancedCostOptimizationMetricsDocumentDeserializerKt.deserializeAdvancedCostOptimizationMetricsDocument(curr));
                    break;
                }
                case "AdvancedDataProtectionMetrics": {
                    builder.setAdvancedDataProtectionMetrics(AdvancedDataProtectionMetricsDocumentDeserializerKt.deserializeAdvancedDataProtectionMetricsDocument(curr));
                    break;
                }
                case "DetailedStatusCodesMetrics": {
                    builder.setDetailedStatusCodesMetrics(DetailedStatusCodesMetricsDocumentDeserializerKt.deserializeDetailedStatusCodesMetricsDocument(curr));
                    break;
                }
                case "StorageLensGroupLevel": {
                    builder.setStorageLensGroupLevel(StorageLensGroupLevelDocumentDeserializerKt.deserializeStorageLensGroupLevelDocument(curr));
                }
            }
            curr.drop();
        }
        builder.correctErrors$s3control();
        return builder.build();
    }
}

