// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.ReplicationRule
import aws.sdk.kotlin.services.s3control.model.ReplicationRuleStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeReplicationRuleDocument(reader: XmlTagReader): ReplicationRule {
    val builder = ReplicationRule.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ID com.amazonaws.s3control#ReplicationRule$ID
            "ID" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#ID`)" }
            // Priority com.amazonaws.s3control#ReplicationRule$Priority
            "Priority" -> builder.priority = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3control#Priority`)" }
            // Prefix com.amazonaws.s3control#ReplicationRule$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#Prefix`)" }
            // Filter com.amazonaws.s3control#ReplicationRule$Filter
            "Filter" -> builder.filter = deserializeReplicationRuleFilterDocument(curr)
            // Status com.amazonaws.s3control#ReplicationRule$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ReplicationRuleStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#ReplicationRuleStatus`)" }
            // SourceSelectionCriteria com.amazonaws.s3control#ReplicationRule$SourceSelectionCriteria
            "SourceSelectionCriteria" -> builder.sourceSelectionCriteria = deserializeSourceSelectionCriteriaDocument(curr)
            // ExistingObjectReplication com.amazonaws.s3control#ReplicationRule$ExistingObjectReplication
            "ExistingObjectReplication" -> builder.existingObjectReplication = deserializeExistingObjectReplicationDocument(curr)
            // Destination com.amazonaws.s3control#ReplicationRule$Destination
            "Destination" -> builder.destination = deserializeDestinationDocument(curr)
            // DeleteMarkerReplication com.amazonaws.s3control#ReplicationRule$DeleteMarkerReplication
            "DeleteMarkerReplication" -> builder.deleteMarkerReplication = deserializeDeleteMarkerReplicationDocument(curr)
            // Bucket com.amazonaws.s3control#ReplicationRule$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#BucketIdentifierString`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
