// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.GetAccessGrantsInstanceResponse
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetAccessGrantsInstanceOperationDeserializer: HttpDeserializer.NonStreaming<GetAccessGrantsInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAccessGrantsInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccessGrantsInstanceError(context, call, payload)
        }
        val builder = GetAccessGrantsInstanceResponse.Builder()

        if (payload != null) {
            deserializeGetAccessGrantsInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAccessGrantsInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessGrantsInstanceOperationBody(builder: GetAccessGrantsInstanceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessGrantsInstanceArn com.amazonaws.s3control#GetAccessGrantsInstanceResult$AccessGrantsInstanceArn
            "AccessGrantsInstanceArn" -> builder.accessGrantsInstanceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsInstanceArn`)" }
            // AccessGrantsInstanceId com.amazonaws.s3control#GetAccessGrantsInstanceResult$AccessGrantsInstanceId
            "AccessGrantsInstanceId" -> builder.accessGrantsInstanceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsInstanceId`)" }
            // CreatedAt com.amazonaws.s3control#GetAccessGrantsInstanceResult$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // IdentityCenterArn com.amazonaws.s3control#GetAccessGrantsInstanceResult$IdentityCenterArn
            "IdentityCenterArn" -> builder.identityCenterArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IdentityCenterArn`)" }
            else -> {}
        }
        curr.drop()
    }
}
