// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.AccessGrantsLocationConfiguration
import aws.sdk.kotlin.services.s3control.model.CreateAccessGrantResponse
import aws.sdk.kotlin.services.s3control.model.Grantee
import aws.sdk.kotlin.services.s3control.model.Permission
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateAccessGrantOperationDeserializer: HttpDeserializer.NonStreaming<CreateAccessGrantResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAccessGrantResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAccessGrantError(context, call, payload)
        }
        val builder = CreateAccessGrantResponse.Builder()

        if (payload != null) {
            deserializeCreateAccessGrantOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAccessGrantError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAccessGrantOperationBody(builder: CreateAccessGrantResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessGrantArn com.amazonaws.s3control#CreateAccessGrantResult$AccessGrantArn
            "AccessGrantArn" -> builder.accessGrantArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantArn`)" }
            // AccessGrantId com.amazonaws.s3control#CreateAccessGrantResult$AccessGrantId
            "AccessGrantId" -> builder.accessGrantId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantId`)" }
            // AccessGrantsLocationConfiguration com.amazonaws.s3control#CreateAccessGrantResult$AccessGrantsLocationConfiguration
            "AccessGrantsLocationConfiguration" -> builder.accessGrantsLocationConfiguration = deserializeAccessGrantsLocationConfigurationDocument(curr)
            // AccessGrantsLocationId com.amazonaws.s3control#CreateAccessGrantResult$AccessGrantsLocationId
            "AccessGrantsLocationId" -> builder.accessGrantsLocationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#AccessGrantsLocationId`)" }
            // ApplicationArn com.amazonaws.s3control#CreateAccessGrantResult$ApplicationArn
            "ApplicationArn" -> builder.applicationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#IdentityCenterApplicationArn`)" }
            // CreatedAt com.amazonaws.s3control#CreateAccessGrantResult$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)" }
            // GrantScope com.amazonaws.s3control#CreateAccessGrantResult$GrantScope
            "GrantScope" -> builder.grantScope = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3control#S3Prefix`)" }
            // Grantee com.amazonaws.s3control#CreateAccessGrantResult$Grantee
            "Grantee" -> builder.grantee = deserializeGranteeDocument(curr)
            // Permission com.amazonaws.s3control#CreateAccessGrantResult$Permission
            "Permission" -> builder.permission = curr.tryData()
                .parse { Permission.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3control#Permission`)" }
            else -> {}
        }
        curr.drop()
    }
}
