// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The filter element sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the `AND` or `OR` logical operator is used.
 */
public class StorageLensGroupFilter private constructor(builder: Builder) {
    /**
     * A logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the `And` logical operator. Only one of each filter condition is allowed.
     */
    public val and: aws.sdk.kotlin.services.s3control.model.StorageLensGroupAndOperator? = builder.and
    /**
     * Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
     */
    public val matchAnyPrefix: List<String>? = builder.matchAnyPrefix
    /**
     * Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
     */
    public val matchAnySuffix: List<String>? = builder.matchAnySuffix
    /**
     * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
     */
    public val matchAnyTag: List<S3Tag>? = builder.matchAnyTag
    /**
     * Contains `DaysGreaterThan` and `DaysLessThan` to define the object age range (minimum and maximum number of days).
     */
    public val matchObjectAge: aws.sdk.kotlin.services.s3control.model.MatchObjectAge? = builder.matchObjectAge
    /**
     * Contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
     */
    public val matchObjectSize: aws.sdk.kotlin.services.s3control.model.MatchObjectSize? = builder.matchObjectSize
    /**
     * A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the listed filter conditions, which are joined by the `Or` logical operator. Only one of each filter condition is allowed.
     */
    public val or: aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator? = builder.or

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageLensGroupFilter(")
        append("and=$and,")
        append("matchAnyPrefix=$matchAnyPrefix,")
        append("matchAnySuffix=$matchAnySuffix,")
        append("matchAnyTag=$matchAnyTag,")
        append("matchObjectAge=$matchObjectAge,")
        append("matchObjectSize=$matchObjectSize,")
        append("or=$or")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = and?.hashCode() ?: 0
        result = 31 * result + (matchAnyPrefix?.hashCode() ?: 0)
        result = 31 * result + (matchAnySuffix?.hashCode() ?: 0)
        result = 31 * result + (matchAnyTag?.hashCode() ?: 0)
        result = 31 * result + (matchObjectAge?.hashCode() ?: 0)
        result = 31 * result + (matchObjectSize?.hashCode() ?: 0)
        result = 31 * result + (or?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageLensGroupFilter

        if (and != other.and) return false
        if (matchAnyPrefix != other.matchAnyPrefix) return false
        if (matchAnySuffix != other.matchAnySuffix) return false
        if (matchAnyTag != other.matchAnyTag) return false
        if (matchObjectAge != other.matchObjectAge) return false
        if (matchObjectSize != other.matchObjectSize) return false
        if (or != other.or) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the `And` logical operator. Only one of each filter condition is allowed.
         */
        public var and: aws.sdk.kotlin.services.s3control.model.StorageLensGroupAndOperator? = null
        /**
         * Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
         */
        public var matchAnyPrefix: List<String>? = null
        /**
         * Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
         */
        public var matchAnySuffix: List<String>? = null
        /**
         * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
         */
        public var matchAnyTag: List<S3Tag>? = null
        /**
         * Contains `DaysGreaterThan` and `DaysLessThan` to define the object age range (minimum and maximum number of days).
         */
        public var matchObjectAge: aws.sdk.kotlin.services.s3control.model.MatchObjectAge? = null
        /**
         * Contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
         */
        public var matchObjectSize: aws.sdk.kotlin.services.s3control.model.MatchObjectSize? = null
        /**
         * A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the listed filter conditions, which are joined by the `Or` logical operator. Only one of each filter condition is allowed.
         */
        public var or: aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter) : this() {
            this.and = x.and
            this.matchAnyPrefix = x.matchAnyPrefix
            this.matchAnySuffix = x.matchAnySuffix
            this.matchAnyTag = x.matchAnyTag
            this.matchObjectAge = x.matchObjectAge
            this.matchObjectSize = x.matchObjectSize
            this.or = x.or
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.StorageLensGroupFilter = StorageLensGroupFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensGroupAndOperator] inside the given [block]
         */
        public fun and(block: aws.sdk.kotlin.services.s3control.model.StorageLensGroupAndOperator.Builder.() -> kotlin.Unit) {
            this.and = aws.sdk.kotlin.services.s3control.model.StorageLensGroupAndOperator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.MatchObjectAge] inside the given [block]
         */
        public fun matchObjectAge(block: aws.sdk.kotlin.services.s3control.model.MatchObjectAge.Builder.() -> kotlin.Unit) {
            this.matchObjectAge = aws.sdk.kotlin.services.s3control.model.MatchObjectAge.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.MatchObjectSize] inside the given [block]
         */
        public fun matchObjectSize(block: aws.sdk.kotlin.services.s3control.model.MatchObjectSize.Builder.() -> kotlin.Unit) {
            this.matchObjectSize = aws.sdk.kotlin.services.s3control.model.MatchObjectSize.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator] inside the given [block]
         */
        public fun or(block: aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator.Builder.() -> kotlin.Unit) {
            this.or = aws.sdk.kotlin.services.s3control.model.StorageLensGroupOrOperator.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
