// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAccessGrantsLocationRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that is making this request.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The S3 path to the location that you are registering. The location scope can be the default S3 location `s3://`, the S3 path to a bucket `s3://<bucket>`, or the S3 path to a bucket and prefix `s3://<bucket>/<prefix>`. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the `engineering/` prefix or object key names that start with the `marketing/campaigns/` prefix.
     */
    public val locationScope: kotlin.String? = builder.locationScope
    /**
     * The Amazon Web Services resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessGrantsLocationRequest(")
        append("accountId=$accountId,")
        append("iamRoleArn=$iamRoleArn,")
        append("locationScope=$locationScope,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (locationScope?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessGrantsLocationRequest

        if (accountId != other.accountId) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (locationScope != other.locationScope) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that is making this request.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The S3 path to the location that you are registering. The location scope can be the default S3 location `s3://`, the S3 path to a bucket `s3://<bucket>`, or the S3 path to a bucket and prefix `s3://<bucket>/<prefix>`. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the `engineering/` prefix or object key names that start with the `marketing/campaigns/` prefix.
         */
        public var locationScope: kotlin.String? = null
        /**
         * The Amazon Web Services resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest) : this() {
            this.accountId = x.accountId
            this.iamRoleArn = x.iamRoleArn
            this.locationScope = x.locationScope
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateAccessGrantsLocationRequest = CreateAccessGrantsLocationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
