// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.RequestedJobStatus
import aws.sdk.kotlin.services.s3control.model.UpdateJobStatusRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateJobStatusOperationSerializer: HttpSerializer.NonStreaming<UpdateJobStatusRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateJobStatusRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.jobId) { "jobId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("jobs"))
                add(PercentEncoding.SmithyLabel.encode("${input.jobId}"))
                add(PercentEncoding.Path.encode("status"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.requestedJobStatus != null) add("requestedJobStatus", input.requestedJobStatus.value)
                if (input.statusUpdateReason != null) add("statusUpdateReason", input.statusUpdateReason)
            }
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        return builder
    }
}
