// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.serde

import aws.sdk.kotlin.services.s3control.model.UpdateAccessGrantsLocationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAccessGrantsLocationOperationSerializer: HttpSerializer.NonStreaming<UpdateAccessGrantsLocationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAccessGrantsLocationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.accessGrantsLocationId) { "accessGrantsLocationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20180820"))
                add(PercentEncoding.Path.encode("accessgrantsinstance"))
                add(PercentEncoding.Path.encode("location"))
                add(PercentEncoding.SmithyLabel.encode("${input.accessGrantsLocationId}"))
            }
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        val payload = serializeUpdateAccessGrantsLocationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeUpdateAccessGrantsLocationOperationBody(context: ExecutionContext, input: UpdateAccessGrantsLocationRequest): ByteArray {
    val serializer = XmlSerializer()
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("IAMRoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("UpdateAccessGrantsLocationRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(IAMROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.iamRoleArn?.let { field(IAMROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
